/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.scanning;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.processor.JandexUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.reflection.ReflectionBeanFactoryCreator;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResteasyReactiveExceptionMappingScanner {
    public static ExceptionMapping createExceptionMappers(IndexView indexView, ApplicationScanningResult result) {
        return ResteasyReactiveExceptionMappingScanner.createExceptionMappers(indexView, result, new ReflectionBeanFactoryCreator());
    }

    public static ExceptionMapping createExceptionMappers(IndexView indexView, ApplicationScanningResult result, Function<String, BeanFactory<?>> factoryCreator) {
        ExceptionMapping ret = ResteasyReactiveExceptionMappingScanner.scanForExceptionMappers(indexView, result);
        ret.initializeDefaultFactories(factoryCreator);
        return ret;
    }

    public static ExceptionMapping scanForExceptionMappers(IndexView index, ApplicationScanningResult result) {
        ExceptionMapping exceptionMapping = new ExceptionMapping();
        Collection exceptionMappers = index.getAllKnownImplementors(ResteasyReactiveDotNames.EXCEPTION_MAPPER);
        for (ClassInfo mapperClass : exceptionMappers) {
            ApplicationScanningResult.KeepProviderResult keepProviderResult = result.keepProvider(mapperClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            List typeParameters = JandexUtil.resolveTypeParameters((DotName)mapperClass.name(), (DotName)ResteasyReactiveDotNames.EXCEPTION_MAPPER, (IndexView)index);
            DotName handledExceptionDotName = ((Type)typeParameters.get(0)).name();
            AnnotationInstance priorityInstance = mapperClass.classAnnotation(ResteasyReactiveDotNames.PRIORITY);
            int priority = 5000;
            if (priorityInstance != null) {
                priority = priorityInstance.value().asInt();
            }
            ResourceExceptionMapper mapper = new ResourceExceptionMapper();
            mapper.setPriority(priority);
            mapper.setClassName(mapperClass.name().toString());
            try {
                Class<?> mappedClass = Class.forName(handledExceptionDotName.toString(), false, Thread.currentThread().getContextClassLoader());
                exceptionMapping.addExceptionMapper(mappedClass, mapper);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load mapped exception: " + handledExceptionDotName);
            }
        }
        return exceptionMapping;
    }
}

