/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.scanning;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.processor.AsmUtil;
import org.jboss.resteasy.reactive.common.processor.IndexedParameter;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.TypeArgMapper;
import org.jboss.resteasy.reactive.common.util.DeploymentUtils;
import org.jboss.resteasy.reactive.common.util.types.TypeSignatureParser;
import org.jboss.resteasy.reactive.multipart.FileUpload;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.DefaultFileUpload;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartSupport;
import org.jboss.resteasy.reactive.server.core.parameters.MultipartFormParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ArrayConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.DelegatingParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionContext;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionTarget;
import org.jboss.resteasy.reactive.server.processor.ServerIndexedParameter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassInjectorTransformer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final String WEB_APPLICATION_EXCEPTION_BINARY_NAME = WebApplicationException.class.getName().replace('.', '/');
    private static final String NOT_FOUND_EXCEPTION_BINARY_NAME = NotFoundException.class.getName().replace('.', '/');
    private static final String BAD_REQUEST_EXCEPTION_BINARY_NAME = BadRequestException.class.getName().replace('.', '/');
    private static final String PARAMETER_CONVERTER_BINARY_NAME = ParameterConverter.class.getName().replace('.', '/');
    private static final String PARAMETER_CONVERTER_DESCRIPTOR = "L" + PARAMETER_CONVERTER_BINARY_NAME + ";";
    private static final String QUARKUS_REST_INJECTION_TARGET_BINARY_NAME = ResteasyReactiveInjectionTarget.class.getName().replace('.', '/');
    private static final String QUARKUS_REST_INJECTION_CONTEXT_BINARY_NAME = ResteasyReactiveInjectionContext.class.getName().replace('.', '/');
    private static final String QUARKUS_REST_INJECTION_CONTEXT_DESCRIPTOR = "L" + QUARKUS_REST_INJECTION_CONTEXT_BINARY_NAME + ";";
    private static final String INJECT_METHOD_NAME = "__quarkus_rest_inject";
    private static final String INJECT_METHOD_DESCRIPTOR = "(" + QUARKUS_REST_INJECTION_CONTEXT_DESCRIPTOR + ")V";
    private static final String QUARKUS_REST_DEPLOYMENT_BINARY_NAME = Deployment.class.getName().replace('.', '/');
    private static final String QUARKUS_REST_DEPLOYMENT_DESCRIPTOR = "L" + QUARKUS_REST_DEPLOYMENT_BINARY_NAME + ";";
    public static final String INIT_CONVERTER_METHOD_NAME = "__quarkus_init_converter__";
    private static final String INIT_CONVERTER_FIELD_NAME = "__quarkus_converter__";
    private static final String INIT_CONVERTER_METHOD_DESCRIPTOR = "(" + QUARKUS_REST_DEPLOYMENT_DESCRIPTOR + ")V";
    private static final String MULTIPART_SUPPORT_BINARY_NAME = MultipartSupport.class.getName().replace('.', '/');
    private static final String OBJECT_BINARY_NAME = Object.class.getName().replace('.', '/');
    private static final String OBJECT_DESCRIPTOR = "L" + OBJECT_BINARY_NAME + ";";
    private static final String STRING_BINARY_NAME = String.class.getName().replace('.', '/');
    private static final String STRING_DESCRIPTOR = "L" + STRING_BINARY_NAME + ";";
    private static final String BYTE_ARRAY_DESCRIPTOR = "[B";
    private static final String INPUT_STREAM_BINARY_NAME = InputStream.class.getName().replace('.', '/');
    private static final String INPUT_STREAM_DESCRIPTOR = "L" + INPUT_STREAM_BINARY_NAME + ";";
    private static final String LIST_BINARY_NAME = List.class.getName().replace('.', '/');
    private static final String LIST_DESCRIPTOR = "L" + LIST_BINARY_NAME + ";";
    private static final String TYPE_BINARY_NAME = Type.class.getName().replace('.', '/');
    private static final String TYPE_DESCRIPTOR = "L" + TYPE_BINARY_NAME + ";";
    private static final String CLASS_BINARY_NAME = Class.class.getName().replace('.', '/');
    private static final String CLASS_DESCRIPTOR = "L" + CLASS_BINARY_NAME + ";";
    private static final String MEDIA_TYPE_BINARY_NAME = MediaType.class.getName().replace('.', '/');
    private static final String MEDIA_TYPE_DESCRIPTOR = "L" + MEDIA_TYPE_BINARY_NAME + ";";
    private static final String DEPLOYMENT_UTILS_BINARY_NAME = DeploymentUtils.class.getName().replace('.', '/');
    private static final String DEPLOYMENT_UTILS_DESCRIPTOR = "L" + DEPLOYMENT_UTILS_BINARY_NAME + ";";
    private static final String TYPE_DESCRIPTOR_PARSER_BINARY_NAME = TypeSignatureParser.class.getName().replace('.', '/');
    private static final String TYPE_DESCRIPTOR_PARSER_DESCRIPTOR = "L" + TYPE_DESCRIPTOR_PARSER_BINARY_NAME + ";";
    private static final String FILE_BINARY_NAME = File.class.getName().replace('.', '/');
    private static final String FILE_DESCRIPTOR = "L" + FILE_BINARY_NAME + ";";
    private static final String PATH_BINARY_NAME = Path.class.getName().replace('.', '/');
    private static final String PATH_DESCRIPTOR = "L" + PATH_BINARY_NAME + ";";
    private static final String DEFAULT_FILE_UPLOAD_BINARY_NAME = DefaultFileUpload.class.getName().replace('.', '/');
    private static final String DEFAULT_FILE_UPLOAD_DESCRIPTOR = "L" + DEFAULT_FILE_UPLOAD_BINARY_NAME + ";";
    private static final String FILE_UPLOAD_BINARY_NAME = FileUpload.class.getName().replace('.', '/');
    private static final String RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME = ResteasyReactiveRequestContext.class.getName().replace('.', '/');
    private static final String RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR = "L" + RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME + ";";
    private final Map<FieldInfo, ServerIndexedParameter> fieldExtractors;
    private final boolean superTypeIsInjectable;
    private final boolean requireCreateBeanParams;
    private IndexView indexView;

    public ClassInjectorTransformer(Map<FieldInfo, ServerIndexedParameter> fieldExtractors, boolean superTypeIsInjectable, boolean requireCreateBeanParams, IndexView indexView) {
        this.fieldExtractors = fieldExtractors;
        this.superTypeIsInjectable = superTypeIsInjectable;
        this.requireCreateBeanParams = requireCreateBeanParams;
        this.indexView = indexView;
    }

    @Override
    public ClassVisitor apply(String classname, ClassVisitor visitor) {
        return new ClassInjectorVisitor(589824, visitor, this.fieldExtractors, this.superTypeIsInjectable, this.requireCreateBeanParams, this.indexView);
    }

    static class ClassInjectorVisitor
    extends ClassVisitor {
        private Map<FieldInfo, ServerIndexedParameter> fieldExtractors;
        private Map<FieldInfo, ServerIndexedParameter> partTypes;
        private String thisName;
        private boolean superTypeIsInjectable;
        private String superTypeName;
        private final boolean requireCreateBeanParams;
        private IndexView indexView;
        private boolean seenClassInit;

        public ClassInjectorVisitor(int api, ClassVisitor classVisitor, Map<FieldInfo, ServerIndexedParameter> fieldExtractors, boolean superTypeIsInjectable, boolean requireCreateBeanParams, IndexView indexView) {
            super(api, classVisitor);
            this.fieldExtractors = fieldExtractors;
            this.superTypeIsInjectable = superTypeIsInjectable;
            this.requireCreateBeanParams = requireCreateBeanParams;
            this.indexView = indexView;
            this.partTypes = new HashMap<FieldInfo, ServerIndexedParameter>();
            for (Map.Entry<FieldInfo, ServerIndexedParameter> entry : fieldExtractors.entrySet()) {
                FieldInfo fieldInfo = entry.getKey();
                ServerIndexedParameter extractor = entry.getValue();
                switch (extractor.getType()) {
                    case FORM: {
                        MultipartFormParamExtractor.Type multipartFormType = this.getMultipartFormType(extractor);
                        if (multipartFormType != MultipartFormParamExtractor.Type.PartType) break;
                        this.partTypes.put(fieldInfo, extractor);
                    }
                }
            }
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            access &= 0xFFFFFFF9;
            access |= 1;
            if (!this.superTypeIsInjectable) {
                String[] newInterfaces = new String[interfaces.length + 1];
                newInterfaces[0] = QUARKUS_REST_INJECTION_TARGET_BINARY_NAME;
                System.arraycopy(interfaces, 0, newInterfaces, 1, interfaces.length);
                super.visit(version, access, name, signature, superName, newInterfaces);
            } else {
                super.visit(version, access, name, signature, superName, interfaces);
            }
            this.superTypeName = superName;
            this.thisName = name;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (!this.partTypes.isEmpty() && name.equals("<clinit>")) {
                this.seenClassInit = true;
                return new MethodVisitor(589824, mv){

                    public void visitEnd() {
                        for (Map.Entry<FieldInfo, ServerIndexedParameter> entry : partTypes.entrySet()) {
                            this.generateMultipartFormStaticInit(this, entry.getKey(), entry.getValue());
                        }
                        super.visitEnd();
                    }
                };
            }
            return mv;
        }

        public void visitEnd() {
            ServerIndexedParameter extractor;
            FieldInfo fieldInfo;
            MethodVisitor injectMethod = this.visitMethod(1, ClassInjectorTransformer.INJECT_METHOD_NAME, INJECT_METHOD_DESCRIPTOR, null, null);
            injectMethod.visitParameter("ctx", 0);
            injectMethod.visitCode();
            if (this.superTypeIsInjectable) {
                injectMethod.visitIntInsn(25, 0);
                injectMethod.visitIntInsn(25, 1);
                injectMethod.visitMethodInsn(183, this.superTypeName, ClassInjectorTransformer.INJECT_METHOD_NAME, INJECT_METHOD_DESCRIPTOR, false);
            }
            for (Map.Entry<FieldInfo, ServerIndexedParameter> entry : this.fieldExtractors.entrySet()) {
                fieldInfo = entry.getKey();
                extractor = entry.getValue();
                switch (extractor.getType()) {
                    case BEAN: {
                        injectMethod.visitIntInsn(25, 0);
                        String typeDescriptor = AsmUtil.getDescriptor((org.jboss.jandex.Type)fieldInfo.type(), name -> null);
                        if (this.requireCreateBeanParams) {
                            String type = fieldInfo.type().name().toString().replace(".", "/");
                            injectMethod.visitTypeInsn(187, type);
                            injectMethod.visitInsn(89);
                            injectMethod.visitMethodInsn(183, type, "<init>", "()V", false);
                            injectMethod.visitInsn(90);
                            injectMethod.visitFieldInsn(181, this.thisName, fieldInfo.name(), typeDescriptor);
                        } else {
                            injectMethod.visitFieldInsn(180, this.thisName, fieldInfo.name(), typeDescriptor);
                        }
                        injectMethod.visitIntInsn(25, 1);
                        injectMethod.visitMethodInsn(185, QUARKUS_REST_INJECTION_TARGET_BINARY_NAME, ClassInjectorTransformer.INJECT_METHOD_NAME, INJECT_METHOD_DESCRIPTOR, true);
                        break;
                    }
                    case ASYNC_RESPONSE: 
                    case BODY: {
                        break;
                    }
                    case CONTEXT: {
                        break;
                    }
                    case FORM: {
                        this.injectParameterWithConverter(injectMethod, "getFormParameter", fieldInfo, extractor, true, true, fieldInfo.hasAnnotation(ResteasyReactiveDotNames.ENCODED));
                        break;
                    }
                    case HEADER: {
                        this.injectParameterWithConverter(injectMethod, "getHeader", fieldInfo, extractor, true, false, false);
                        break;
                    }
                    case MATRIX: {
                        this.injectParameterWithConverter(injectMethod, "getMatrixParameter", fieldInfo, extractor, true, true, fieldInfo.hasAnnotation(ResteasyReactiveDotNames.ENCODED));
                        break;
                    }
                    case COOKIE: {
                        this.injectParameterWithConverter(injectMethod, "getCookieParameter", fieldInfo, extractor, false, false, false);
                        break;
                    }
                    case PATH: {
                        this.injectParameterWithConverter(injectMethod, "getPathParameter", fieldInfo, extractor, false, true, fieldInfo.hasAnnotation(ResteasyReactiveDotNames.ENCODED));
                        break;
                    }
                    case QUERY: {
                        this.injectParameterWithConverter(injectMethod, "getQueryParameter", fieldInfo, extractor, true, true, fieldInfo.hasAnnotation(ResteasyReactiveDotNames.ENCODED));
                        break;
                    }
                }
            }
            injectMethod.visitInsn(177);
            injectMethod.visitEnd();
            injectMethod.visitMaxs(0, 0);
            for (Map.Entry<FieldInfo, ServerIndexedParameter> entry : this.fieldExtractors.entrySet()) {
                fieldInfo = entry.getKey();
                extractor = entry.getValue();
                switch (extractor.getType()) {
                    case FORM: {
                        MultipartFormParamExtractor.Type multipartFormType = this.getMultipartFormType(extractor);
                        if (multipartFormType == MultipartFormParamExtractor.Type.PartType) {
                            this.generateMultipartFormFields(fieldInfo, extractor);
                        }
                    }
                    case HEADER: 
                    case MATRIX: 
                    case COOKIE: 
                    case PATH: 
                    case QUERY: {
                        ParameterConverterSupplier converter = extractor.getConverter();
                        if (converter == null) break;
                        this.generateConverterInitMethod(fieldInfo, converter, extractor.isSingle());
                    }
                }
            }
            if (!this.seenClassInit && !this.partTypes.isEmpty()) {
                MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
                for (Map.Entry<FieldInfo, ServerIndexedParameter> entry : this.partTypes.entrySet()) {
                    this.generateMultipartFormStaticInit(mv, entry.getKey(), entry.getValue());
                }
                mv.visitInsn(177);
                mv.visitEnd();
                mv.visitMaxs(0, 0);
            }
            super.visitEnd();
        }

        private void generateMultipartFormFields(FieldInfo fieldInfo, ServerIndexedParameter extractor) {
            super.visitField(10, fieldInfo.name() + "_type", CLASS_DESCRIPTOR, null, null).visitEnd();
            super.visitField(10, fieldInfo.name() + "_genericType", TYPE_DESCRIPTOR, null, null).visitEnd();
            super.visitField(10, fieldInfo.name() + "_mediaType", MEDIA_TYPE_DESCRIPTOR, null, null).visitEnd();
        }

        private void generateMultipartFormStaticInit(MethodVisitor mv, FieldInfo fieldInfo, ServerIndexedParameter extractor) {
            org.jboss.jandex.Type type = fieldInfo.type();
            if (!extractor.isSingle()) {
                boolean isArray = type.kind() == Type.Kind.ARRAY;
                type = isArray ? type.asArrayType().component() : (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
            }
            mv.visitLdcInsn((Object)type.name().toString());
            mv.visitMethodInsn(184, DEPLOYMENT_UTILS_BINARY_NAME, "loadClass", "(" + STRING_DESCRIPTOR + ")" + CLASS_DESCRIPTOR, false);
            mv.visitFieldInsn(179, this.thisName, fieldInfo.name() + "_type", CLASS_DESCRIPTOR);
            if (type.kind() != Type.Kind.CLASS && type.kind() != Type.Kind.PRIMITIVE) {
                TypeArgMapper typeArgMapper = new TypeArgMapper(fieldInfo.declaringClass(), this.indexView);
                String signature = AsmUtil.getSignature((org.jboss.jandex.Type)type, (Function)typeArgMapper);
                mv.visitLdcInsn((Object)signature);
                mv.visitMethodInsn(184, TYPE_DESCRIPTOR_PARSER_BINARY_NAME, "parse", "(" + STRING_DESCRIPTOR + ")" + TYPE_DESCRIPTOR, false);
                mv.visitFieldInsn(179, this.thisName, fieldInfo.name() + "_genericType", TYPE_DESCRIPTOR);
            } else {
                mv.visitFieldInsn(178, this.thisName, fieldInfo.name() + "_type", CLASS_DESCRIPTOR);
                mv.visitFieldInsn(179, this.thisName, fieldInfo.name() + "_genericType", TYPE_DESCRIPTOR);
            }
            String mediaType = ((AnnotationInstance)extractor.getAnns().get(ResteasyReactiveDotNames.PART_TYPE_NAME)).value().asString();
            mv.visitLdcInsn((Object)mediaType);
            mv.visitMethodInsn(184, MEDIA_TYPE_BINARY_NAME, "valueOf", "(" + STRING_DESCRIPTOR + ")" + MEDIA_TYPE_DESCRIPTOR, false);
            mv.visitFieldInsn(179, this.thisName, fieldInfo.name() + "_mediaType", MEDIA_TYPE_DESCRIPTOR);
        }

        private void generateConverterInitMethod(FieldInfo fieldInfo, ParameterConverterSupplier converter, boolean single) {
            String converterFieldName = ClassInjectorTransformer.INIT_CONVERTER_FIELD_NAME + fieldInfo.name();
            FieldVisitor field = this.visitField(10, converterFieldName, PARAMETER_CONVERTER_DESCRIPTOR, null, null);
            field.visitEnd();
            converter = this.removeRuntimeResolvedConverterDelegate(converter);
            String delegateBinaryName = null;
            if (converter instanceof DelegatingParameterConverterSupplier) {
                ParameterConverterSupplier delegate = this.removeRuntimeResolvedConverterDelegate(((DelegatingParameterConverterSupplier)converter).getDelegate());
                if (delegate != null) {
                    delegateBinaryName = delegate.getClassName().replace('.', '/');
                }
            } else {
                delegateBinaryName = converter.getClassName().replace('.', '/');
            }
            MethodVisitor initConverterMethod = this.visitMethod(9, ClassInjectorTransformer.INIT_CONVERTER_METHOD_NAME + fieldInfo.name(), INIT_CONVERTER_METHOD_DESCRIPTOR, null, null);
            initConverterMethod.visitParameter("deployment", 0);
            initConverterMethod.visitCode();
            initConverterMethod.visitIntInsn(25, 0);
            initConverterMethod.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)("L" + this.thisName + ";")));
            initConverterMethod.visitLdcInsn((Object)fieldInfo.name());
            initConverterMethod.visitLdcInsn((Object)single);
            initConverterMethod.visitMethodInsn(182, QUARKUS_REST_DEPLOYMENT_BINARY_NAME, "getRuntimeParamConverter", "(Ljava/lang/Class;Ljava/lang/String;Z)" + PARAMETER_CONVERTER_DESCRIPTOR, false);
            if (delegateBinaryName != null) {
                Label notNull = new Label();
                initConverterMethod.visitInsn(89);
                initConverterMethod.visitJumpInsn(199, notNull);
                initConverterMethod.visitInsn(87);
                initConverterMethod.visitTypeInsn(187, delegateBinaryName);
                initConverterMethod.visitInsn(89);
                initConverterMethod.visitMethodInsn(183, delegateBinaryName, "<init>", "()V", false);
                initConverterMethod.visitTypeInsn(192, PARAMETER_CONVERTER_BINARY_NAME);
                initConverterMethod.visitLabel(notNull);
            }
            if (converter instanceof DelegatingParameterConverterSupplier) {
                String delegatorBinaryName = converter.getClassName().replace('.', '/');
                initConverterMethod.visitTypeInsn(187, delegatorBinaryName);
                initConverterMethod.visitInsn(90);
                initConverterMethod.visitInsn(95);
                if (converter instanceof ArrayConverter.ArraySupplier) {
                    org.jboss.jandex.Type componentType = fieldInfo.type().asArrayType().component();
                    initConverterMethod.visitLdcInsn((Object)componentType.name().toString('.'));
                    initConverterMethod.visitMethodInsn(183, delegatorBinaryName, "<init>", "(" + PARAMETER_CONVERTER_DESCRIPTOR + STRING_DESCRIPTOR + ")V", false);
                } else {
                    initConverterMethod.visitMethodInsn(183, delegatorBinaryName, "<init>", "(" + PARAMETER_CONVERTER_DESCRIPTOR + ")V", false);
                }
            }
            initConverterMethod.visitFieldInsn(179, this.thisName, converterFieldName, PARAMETER_CONVERTER_DESCRIPTOR);
            initConverterMethod.visitInsn(177);
            initConverterMethod.visitEnd();
            initConverterMethod.visitMaxs(0, 0);
        }

        private ParameterConverterSupplier removeRuntimeResolvedConverterDelegate(ParameterConverterSupplier converter) {
            ParameterConverterSupplier delegate;
            if (converter instanceof RuntimeResolvedConverter.Supplier && (delegate = ((RuntimeResolvedConverter.Supplier)converter).getDelegate()) != null) {
                return delegate;
            }
            return converter;
        }

        private void injectParameterWithConverter(MethodVisitor injectMethod, String methodName, FieldInfo fieldInfo, ServerIndexedParameter extractor, boolean extraSingleParameter, boolean extraEncodedParam, boolean encoded) {
            Label tryEnd = null;
            Label tryWebAppHandler = null;
            Label tryHandler = null;
            switch (extractor.getType()) {
                case FORM: 
                case HEADER: 
                case MATRIX: 
                case COOKIE: 
                case PATH: 
                case QUERY: {
                    Label tryStart = new Label();
                    tryEnd = new Label();
                    tryWebAppHandler = new Label();
                    tryHandler = new Label();
                    injectMethod.visitTryCatchBlock(tryStart, tryEnd, tryWebAppHandler, WEB_APPLICATION_EXCEPTION_BINARY_NAME);
                    injectMethod.visitTryCatchBlock(tryStart, tryEnd, tryHandler, "java/lang/Throwable");
                    injectMethod.visitLabel(tryStart);
                }
            }
            MultipartFormParamExtractor.Type multipartType = this.getMultipartFormType(extractor);
            if (multipartType == null) {
                this.loadParameter(injectMethod, methodName, extractor, extraSingleParameter, extraEncodedParam, encoded);
            } else {
                this.loadMultipartParameter(injectMethod, fieldInfo, extractor, multipartType);
            }
            Label valueWasNull = null;
            if (!extractor.isOptional()) {
                valueWasNull = new Label();
                injectMethod.visitInsn(89);
                injectMethod.visitJumpInsn(198, valueWasNull);
            }
            this.convertParameter(injectMethod, extractor, fieldInfo);
            injectMethod.visitIntInsn(25, 0);
            injectMethod.visitInsn(95);
            if (fieldInfo.type().kind() == Type.Kind.PRIMITIVE) {
                AsmUtil.unboxIfRequired((MethodVisitor)injectMethod, (org.jboss.jandex.Type)fieldInfo.type());
            } else {
                injectMethod.visitTypeInsn(192, fieldInfo.type().name().toString().replace('.', '/'));
            }
            injectMethod.visitFieldInsn(181, this.thisName, fieldInfo.name(), AsmUtil.getDescriptor((org.jboss.jandex.Type)fieldInfo.type(), name -> null));
            Label endLabel = new Label();
            injectMethod.visitJumpInsn(167, endLabel);
            if (valueWasNull != null) {
                injectMethod.visitLabel(valueWasNull);
            }
            injectMethod.visitInsn(87);
            if (tryEnd != null) {
                String exceptionBinaryName;
                injectMethod.visitJumpInsn(167, endLabel);
                injectMethod.visitLabel(tryEnd);
                injectMethod.visitLabel(tryWebAppHandler);
                injectMethod.visitInsn(191);
                injectMethod.visitLabel(tryHandler);
                switch (extractor.getType()) {
                    case MATRIX: 
                    case PATH: 
                    case QUERY: {
                        exceptionBinaryName = NOT_FOUND_EXCEPTION_BINARY_NAME;
                        break;
                    }
                    case FORM: 
                    case HEADER: 
                    case COOKIE: {
                        exceptionBinaryName = BAD_REQUEST_EXCEPTION_BINARY_NAME;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Should not have been trying to catch exceptions for parameter of type " + extractor.getType());
                    }
                }
                injectMethod.visitTypeInsn(187, exceptionBinaryName);
                injectMethod.visitInsn(90);
                injectMethod.visitInsn(95);
                injectMethod.visitMethodInsn(183, exceptionBinaryName, "<init>", "(Ljava/lang/Throwable;)V", false);
                injectMethod.visitInsn(191);
            }
            injectMethod.visitLabel(endLabel);
        }

        private void loadMultipartParameter(MethodVisitor injectMethod, FieldInfo fieldInfo, ServerIndexedParameter param, MultipartFormParamExtractor.Type multipartType) {
            switch (multipartType) {
                case String: {
                    this.invokeMultipartSupport(param, injectMethod, "getString", STRING_DESCRIPTOR);
                    break;
                }
                case ByteArray: {
                    this.invokeMultipartSupport(param, injectMethod, "getByteArray", ClassInjectorTransformer.BYTE_ARRAY_DESCRIPTOR);
                    break;
                }
                case InputStream: {
                    this.invokeMultipartSupport(param, injectMethod, "getInputStream", INPUT_STREAM_DESCRIPTOR);
                    break;
                }
                case FileUpload: {
                    if (param.getName().equals("*")) {
                        injectMethod.visitIntInsn(25, 1);
                        injectMethod.visitTypeInsn(192, RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME);
                        injectMethod.visitMethodInsn(184, MULTIPART_SUPPORT_BINARY_NAME, "getFileUploads", "(" + RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR + ")" + LIST_DESCRIPTOR, false);
                        break;
                    }
                    this.invokeMultipartSupport(param, injectMethod, "getFileUpload", DEFAULT_FILE_UPLOAD_DESCRIPTOR);
                    break;
                }
                case File: {
                    if (param.isSingle()) {
                        injectMethod.visitLdcInsn((Object)param.getName());
                        injectMethod.visitIntInsn(25, 1);
                        injectMethod.visitTypeInsn(192, RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME);
                        injectMethod.visitMethodInsn(184, MULTIPART_SUPPORT_BINARY_NAME, "getFileUpload", "(" + STRING_DESCRIPTOR + RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR + ")" + DEFAULT_FILE_UPLOAD_DESCRIPTOR, false);
                        Label ifNull = new Label();
                        Label endIf = new Label();
                        injectMethod.visitInsn(89);
                        injectMethod.visitJumpInsn(198, ifNull);
                        injectMethod.visitMethodInsn(182, DEFAULT_FILE_UPLOAD_BINARY_NAME, "uploadedFile", "()" + PATH_DESCRIPTOR, false);
                        injectMethod.visitMethodInsn(185, PATH_BINARY_NAME, "toFile", "()" + FILE_DESCRIPTOR, true);
                        injectMethod.visitJumpInsn(167, endIf);
                        injectMethod.visitLabel(ifNull);
                        injectMethod.visitInsn(87);
                        injectMethod.visitInsn(1);
                        injectMethod.visitLabel(endIf);
                        break;
                    }
                    injectMethod.visitLdcInsn((Object)param.getName());
                    injectMethod.visitIntInsn(25, 1);
                    injectMethod.visitTypeInsn(192, RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME);
                    injectMethod.visitMethodInsn(184, MULTIPART_SUPPORT_BINARY_NAME, "getJavaIOFileUploads", "(" + STRING_DESCRIPTOR + RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR + ")" + LIST_DESCRIPTOR, false);
                    break;
                }
                case Path: {
                    if (param.isSingle()) {
                        injectMethod.visitLdcInsn((Object)param.getName());
                        injectMethod.visitIntInsn(25, 1);
                        injectMethod.visitTypeInsn(192, RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME);
                        injectMethod.visitMethodInsn(184, MULTIPART_SUPPORT_BINARY_NAME, "getFileUpload", "(" + STRING_DESCRIPTOR + RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR + ")" + DEFAULT_FILE_UPLOAD_DESCRIPTOR, false);
                        Label ifNull = new Label();
                        Label endIf = new Label();
                        injectMethod.visitInsn(89);
                        injectMethod.visitJumpInsn(198, ifNull);
                        injectMethod.visitMethodInsn(182, DEFAULT_FILE_UPLOAD_BINARY_NAME, "uploadedFile", "()" + PATH_DESCRIPTOR, false);
                        injectMethod.visitJumpInsn(167, endIf);
                        injectMethod.visitLabel(ifNull);
                        injectMethod.visitInsn(87);
                        injectMethod.visitInsn(1);
                        injectMethod.visitLabel(endIf);
                        break;
                    }
                    injectMethod.visitLdcInsn((Object)param.getName());
                    injectMethod.visitIntInsn(25, 1);
                    injectMethod.visitTypeInsn(192, RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME);
                    injectMethod.visitMethodInsn(184, MULTIPART_SUPPORT_BINARY_NAME, "getJavaPathFileUploads", "(" + STRING_DESCRIPTOR + RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR + ")" + LIST_DESCRIPTOR, false);
                    break;
                }
                case PartType: {
                    String methodName;
                    String returnDescriptor;
                    String firstParamDescriptor;
                    injectMethod.visitIntInsn(25, 1);
                    injectMethod.visitLdcInsn((Object)param.getName());
                    injectMethod.visitLdcInsn((Object)param.isSingle());
                    injectMethod.visitLdcInsn((Object)false);
                    injectMethod.visitMethodInsn(185, QUARKUS_REST_INJECTION_CONTEXT_BINARY_NAME, "getFormParameter", "(Ljava/lang/String;ZZ)Ljava/lang/Object;", true);
                    injectMethod.visitTypeInsn(192, param.isSingle() ? STRING_BINARY_NAME : LIST_BINARY_NAME);
                    injectMethod.visitFieldInsn(178, this.thisName, fieldInfo.name() + "_type", CLASS_DESCRIPTOR);
                    injectMethod.visitFieldInsn(178, this.thisName, fieldInfo.name() + "_genericType", TYPE_DESCRIPTOR);
                    injectMethod.visitFieldInsn(178, this.thisName, fieldInfo.name() + "_mediaType", MEDIA_TYPE_DESCRIPTOR);
                    injectMethod.visitIntInsn(25, 1);
                    injectMethod.visitTypeInsn(192, RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME);
                    injectMethod.visitLdcInsn((Object)param.getName());
                    if (param.isSingle()) {
                        firstParamDescriptor = STRING_DESCRIPTOR;
                        returnDescriptor = OBJECT_DESCRIPTOR;
                        methodName = "convertFormAttribute";
                    } else {
                        firstParamDescriptor = LIST_DESCRIPTOR;
                        returnDescriptor = LIST_DESCRIPTOR;
                        methodName = "convertFormAttributes";
                    }
                    injectMethod.visitMethodInsn(184, MULTIPART_SUPPORT_BINARY_NAME, methodName, "(" + firstParamDescriptor + CLASS_DESCRIPTOR + TYPE_DESCRIPTOR + MEDIA_TYPE_DESCRIPTOR + RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR + STRING_DESCRIPTOR + ")" + returnDescriptor, false);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown multipart type: " + multipartType);
                }
            }
        }

        private void invokeMultipartSupport(ServerIndexedParameter param, MethodVisitor injectMethod, String singleOperationName, String singleOperationReturnDescriptor) {
            if (param.isSingle()) {
                injectMethod.visitLdcInsn((Object)param.getName());
                injectMethod.visitIntInsn(25, 1);
                injectMethod.visitTypeInsn(192, RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME);
                injectMethod.visitMethodInsn(184, MULTIPART_SUPPORT_BINARY_NAME, singleOperationName, "(" + STRING_DESCRIPTOR + RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR + ")" + singleOperationReturnDescriptor, false);
            } else {
                injectMethod.visitLdcInsn((Object)param.getName());
                injectMethod.visitIntInsn(25, 1);
                injectMethod.visitTypeInsn(192, RESTEASY_REACTIVE_REQUEST_CONTEXT_BINARY_NAME);
                injectMethod.visitMethodInsn(184, MULTIPART_SUPPORT_BINARY_NAME, singleOperationName + "s", "(" + STRING_DESCRIPTOR + RESTEASY_REACTIVE_REQUEST_CONTEXT_DESCRIPTOR + ")" + LIST_DESCRIPTOR, false);
            }
        }

        private MultipartFormParamExtractor.Type getMultipartFormType(ServerIndexedParameter param) {
            if (param.getType() != ParameterType.FORM) {
                return null;
            }
            AnnotationInstance partType = (AnnotationInstance)param.getAnns().get(ResteasyReactiveDotNames.PART_TYPE_NAME);
            String mimeType = null;
            if (partType != null && partType.value() != null && "text/plain".equals(mimeType = partType.value().asString())) {
                mimeType = null;
            }
            if (param.getElementType().equals(FileUpload.class.getName())) {
                return MultipartFormParamExtractor.Type.FileUpload;
            }
            if (param.getElementType().equals(File.class.getName())) {
                return MultipartFormParamExtractor.Type.File;
            }
            if (param.getElementType().equals(Path.class.getName())) {
                return MultipartFormParamExtractor.Type.Path;
            }
            if (param.getElementType().equals(String.class.getName())) {
                return MultipartFormParamExtractor.Type.String;
            }
            if (param.getElementType().equals(InputStream.class.getName())) {
                return MultipartFormParamExtractor.Type.InputStream;
            }
            if (param.getParamType().kind() == Type.Kind.ARRAY && param.getParamType().asArrayType().component().kind() == Type.Kind.PRIMITIVE && param.getParamType().asArrayType().component().asPrimitiveType().primitive() == PrimitiveType.Primitive.BYTE) {
                return MultipartFormParamExtractor.Type.ByteArray;
            }
            if (mimeType != null && !mimeType.equals("text/plain")) {
                return MultipartFormParamExtractor.Type.PartType;
            }
            return null;
        }

        private void convertParameter(MethodVisitor injectMethod, ServerIndexedParameter extractor, FieldInfo fieldInfo) {
            ParameterConverterSupplier converter = extractor.getConverter();
            if (converter != null) {
                String converterFieldName = ClassInjectorTransformer.INIT_CONVERTER_FIELD_NAME + fieldInfo.name();
                injectMethod.visitFieldInsn(178, this.thisName, converterFieldName, PARAMETER_CONVERTER_DESCRIPTOR);
                injectMethod.visitInsn(95);
                injectMethod.visitMethodInsn(185, PARAMETER_CONVERTER_BINARY_NAME, "convert", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            }
        }

        private void loadParameter(MethodVisitor injectMethod, String methodName, IndexedParameter extractor, boolean extraSingleParameter, boolean extraEncodedParam, boolean encoded) {
            String methodSignature;
            injectMethod.visitIntInsn(25, 1);
            injectMethod.visitLdcInsn((Object)extractor.getName());
            if (extraEncodedParam && extraSingleParameter) {
                injectMethod.visitLdcInsn((Object)extractor.isSingle());
                injectMethod.visitLdcInsn((Object)encoded);
                methodSignature = "(Ljava/lang/String;ZZ)Ljava/lang/Object;";
            } else if (extraEncodedParam) {
                injectMethod.visitLdcInsn((Object)encoded);
                methodSignature = "(Ljava/lang/String;Z)Ljava/lang/String;";
            } else if (extraSingleParameter) {
                injectMethod.visitLdcInsn((Object)extractor.isSingle());
                methodSignature = "(Ljava/lang/String;Z)Ljava/lang/Object;";
            } else {
                methodSignature = "(Ljava/lang/String;)Ljava/lang/String;";
            }
            injectMethod.visitMethodInsn(185, QUARKUS_REST_INJECTION_CONTEXT_BINARY_NAME, methodName, methodSignature, true);
            if (extractor.getDefaultValue() != null) {
                injectMethod.visitInsn(89);
                Label wasNonNullTarget = new Label();
                Label setDefaultValueTarget = new Label();
                injectMethod.visitJumpInsn(198, setDefaultValueTarget);
                if (extractor.isObtainedAsCollection()) {
                    injectMethod.visitInsn(89);
                    injectMethod.visitTypeInsn(192, "java/util/Collection");
                    injectMethod.visitMethodInsn(185, "java/util/Collection", "isEmpty", "()Z", true);
                    injectMethod.visitJumpInsn(154, setDefaultValueTarget);
                }
                injectMethod.visitJumpInsn(167, wasNonNullTarget);
                injectMethod.visitLabel(setDefaultValueTarget);
                injectMethod.visitInsn(87);
                injectMethod.visitLdcInsn((Object)extractor.getDefaultValue());
                injectMethod.visitLabel(wasNonNullTarget);
            }
        }
    }
}

