/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.scanning;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.Cache;
import org.jboss.resteasy.reactive.NoCache;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.common.util.ExtendedCacheControl;
import org.jboss.resteasy.reactive.server.handlers.CacheControlHandler;
import org.jboss.resteasy.reactive.server.model.FixedHandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class CacheControlScanner
implements MethodScanner {
    private static final DotName NO_CACHE = DotName.createSimple((String)NoCache.class.getName());
    private static final DotName CACHE = DotName.createSimple((String)Cache.class.getName());

    @Override
    public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        AnnotationStore annotationStore = (AnnotationStore)methodContext.get("ANNOTATION_STORE");
        ExtendedCacheControl cacheControl = this.noCacheToCacheControl(annotationStore.getAnnotation((AnnotationTarget)method, NO_CACHE));
        if (cacheControl != null) {
            if (method.annotation(CACHE) != null) {
                throw new IllegalStateException("A resource method cannot be simultaneously annotated with '@Cache' and '@NoCache'. Offending method is '" + method.name() + "' of class '" + method.declaringClass().name() + "'");
            }
            return this.cacheControlToCustomizerList(cacheControl);
        }
        cacheControl = this.noCacheToCacheControl(annotationStore.getAnnotation((AnnotationTarget)actualEndpointClass, NO_CACHE));
        if (cacheControl != null) {
            if (actualEndpointClass.classAnnotation(CACHE) != null) {
                throw new IllegalStateException("A resource class cannot be simultaneously annotated with '@Cache' and '@NoCache'. Offending class is '" + actualEndpointClass.name() + "'");
            }
            return this.cacheControlToCustomizerList(cacheControl);
        }
        cacheControl = this.cacheToCacheControl(method.annotation(CACHE));
        if (cacheControl != null) {
            return this.cacheControlToCustomizerList(cacheControl);
        }
        cacheControl = this.cacheToCacheControl(actualEndpointClass.classAnnotation(CACHE));
        if (cacheControl != null) {
            return this.cacheControlToCustomizerList(cacheControl);
        }
        return Collections.emptyList();
    }

    private ExtendedCacheControl noCacheToCacheControl(AnnotationInstance noCacheInstance) {
        String[] fields;
        if (noCacheInstance == null) {
            return null;
        }
        ExtendedCacheControl cacheControl = new ExtendedCacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
        AnnotationValue fieldsValue = noCacheInstance.value("fields");
        if (fieldsValue != null && (fields = fieldsValue.asStringArray()) != null && fields.length > 0) {
            cacheControl.getNoCacheFields().addAll(Arrays.asList(fields));
        }
        return cacheControl;
    }

    private ExtendedCacheControl cacheToCacheControl(AnnotationInstance cacheInstance) {
        AnnotationValue noCacheValue;
        AnnotationValue isPrivateValue;
        AnnotationValue proxyRevalidateValue;
        AnnotationValue noTransformValue;
        AnnotationValue noStoreValue;
        int sMaxAge;
        AnnotationValue sMaxAgeValue;
        int maxAge;
        if (cacheInstance == null) {
            return null;
        }
        ExtendedCacheControl cacheControl = new ExtendedCacheControl();
        AnnotationValue maxAgeValue = cacheInstance.value("maxAge");
        if (maxAgeValue != null && (maxAge = maxAgeValue.asInt()) > -1) {
            cacheControl.setMaxAge(maxAge);
        }
        if ((sMaxAgeValue = cacheInstance.value("sMaxAge")) != null && (sMaxAge = sMaxAgeValue.asInt()) > -1) {
            cacheControl.setSMaxAge(sMaxAge);
        }
        if ((noStoreValue = cacheInstance.value("noStore")) != null) {
            cacheControl.setNoStore(noStoreValue.asBoolean());
        }
        if ((noTransformValue = cacheInstance.value("noTransform")) != null) {
            cacheControl.setNoTransform(noTransformValue.asBoolean());
        } else {
            cacheControl.setNoTransform(false);
        }
        AnnotationValue mustRevalidateValue = cacheInstance.value("mustRevalidate");
        if (mustRevalidateValue != null) {
            cacheControl.setMustRevalidate(mustRevalidateValue.asBoolean());
        }
        if ((proxyRevalidateValue = cacheInstance.value("proxyRevalidate")) != null) {
            cacheControl.setProxyRevalidate(proxyRevalidateValue.asBoolean());
        }
        if ((isPrivateValue = cacheInstance.value("isPrivate")) != null) {
            cacheControl.setPrivate(isPrivateValue.asBoolean());
        }
        if ((noCacheValue = cacheInstance.value("noCache")) != null) {
            cacheControl.setNoCache(noCacheValue.asBoolean());
        }
        return cacheControl;
    }

    private List<HandlerChainCustomizer> cacheControlToCustomizerList(ExtendedCacheControl cacheControl) {
        CacheControlHandler handler = new CacheControlHandler();
        handler.setCacheControl(cacheControl);
        return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)handler, HandlerChainCustomizer.Phase.AFTER_RESPONSE_CREATED));
    }
}

