/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.scanning;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.model.ResourceDynamicFeature;
import org.jboss.resteasy.reactive.common.model.ResourceFeature;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.server.model.DynamicFeatures;
import org.jboss.resteasy.reactive.server.model.Features;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResteasyReactiveFeatureScanner {
    public static Features createFeatures(IndexView indexView, ApplicationScanningResult result) {
        return ResteasyReactiveFeatureScanner.createFeatures(indexView, result, null);
    }

    public static Features createFeatures(IndexView indexView, ApplicationScanningResult result, Function<String, BeanFactory<?>> factoryCreator) {
        Features features = new Features();
        for (String i : ResteasyReactiveFeatureScanner.scanForFeatures(indexView, result)) {
            ResourceFeature resourceFeature = new ResourceFeature();
            resourceFeature.setClassName(i);
            if (factoryCreator != null) {
                resourceFeature.setFactory(factoryCreator.apply(i));
            }
            features.addFeature(resourceFeature);
        }
        return features;
    }

    public static DynamicFeatures createDynamicFeatures(IndexView indexView, ApplicationScanningResult result) {
        return ResteasyReactiveFeatureScanner.createDynamicFeatures(indexView, result, null);
    }

    public static DynamicFeatures createDynamicFeatures(IndexView indexView, ApplicationScanningResult result, Function<String, BeanFactory<?>> factoryCreator) {
        DynamicFeatures features = new DynamicFeatures();
        for (String i : ResteasyReactiveFeatureScanner.scanForDynamicFeatures(indexView, result)) {
            ResourceDynamicFeature resourceFeature = new ResourceDynamicFeature();
            resourceFeature.setClassName(i);
            if (factoryCreator != null) {
                resourceFeature.setFactory(factoryCreator.apply(i));
            }
            features.addFeature(resourceFeature);
        }
        return features;
    }

    public static Set<String> scanForFeatures(IndexView index, ApplicationScanningResult applicationScanningResult) {
        Collection features = index.getAllKnownImplementors(ResteasyReactiveDotNames.FEATURE);
        HashSet<String> ret = new HashSet<String>();
        for (ClassInfo featureClass : features) {
            ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationScanningResult.keepProvider(featureClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            ret.add(featureClass.name().toString());
        }
        return ret;
    }

    public static Set<String> scanForDynamicFeatures(IndexView index, ApplicationScanningResult applicationScanningResult) {
        Collection features = index.getAllKnownImplementors(ResteasyReactiveDotNames.DYNAMIC_FEATURE);
        HashSet<String> ret = new HashSet<String>();
        for (ClassInfo featureClass : features) {
            ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationScanningResult.keepProvider(featureClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            ret.add(featureClass.name().toString());
        }
        return ret;
    }
}

