/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.vertx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.vertx.VertxBufferImpl;
import org.jboss.resteasy.reactive.server.vertx.VertxResteasyReactiveRequestContext;

public class ResteasyReactiveOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.quarkus-rest");
    private final ResteasyReactiveRequestContext context;
    protected final HttpServerRequest request;
    private ByteBuf pooledBuffer;
    private long written;
    private boolean committed;
    private boolean closed;
    private boolean finished;
    protected boolean waitingForDrain;
    protected boolean drainHandlerRegistered;
    protected boolean first = true;
    protected Throwable throwable;
    private ByteArrayOutputStream overflow;

    public ResteasyReactiveOutputStream(VertxResteasyReactiveRequestContext context) {
        this.context = context;
        this.request = context.getContext().request();
        this.request.response().exceptionHandler((Handler)new Handler<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Throwable event) {
                ResteasyReactiveOutputStream.this.throwable = event;
                log.debugf(event, "IO Exception ", new Object[0]);
                ResteasyReactiveOutputStream.this.terminateResponse();
                ResteasyReactiveOutputStream.this.request.connection().close();
                HttpConnection httpConnection = ResteasyReactiveOutputStream.this.request.connection();
                synchronized (httpConnection) {
                    if (ResteasyReactiveOutputStream.this.waitingForDrain) {
                        ResteasyReactiveOutputStream.this.request.connection().notify();
                    }
                }
            }
        });
        this.request.response().endHandler((Handler)new Handler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Void event) {
                HttpConnection httpConnection = ResteasyReactiveOutputStream.this.request.connection();
                synchronized (httpConnection) {
                    if (ResteasyReactiveOutputStream.this.waitingForDrain) {
                        ResteasyReactiveOutputStream.this.request.connection().notify();
                    }
                }
                ResteasyReactiveOutputStream.this.terminateResponse();
            }
        });
    }

    public void terminateResponse() {
    }

    Buffer createBuffer(ByteBuf data) {
        return new VertxBufferImpl(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf data, boolean last) throws IOException {
        if (last && data == null) {
            this.request.response().end();
            return;
        }
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            try {
                boolean bufferRequired;
                boolean bl = bufferRequired = this.awaitWriteable() || this.overflow != null && this.overflow.size() > 0;
                if (bufferRequired) {
                    this.registerDrainHandler();
                    if (this.overflow == null) {
                        this.overflow = new ByteArrayOutputStream();
                    }
                    if (data.hasArray()) {
                        this.overflow.write(data.array(), data.arrayOffset() + data.readerIndex(), data.readableBytes());
                    } else {
                        data.getBytes(data.readerIndex(), (OutputStream)this.overflow, data.readableBytes());
                    }
                    if (last) {
                        this.closed = true;
                    }
                } else if (last) {
                    this.request.response().end(this.createBuffer(data));
                } else {
                    this.request.response().write((Object)this.createBuffer(data));
                }
            }
            catch (Exception e) {
                if (data != null && data.refCnt() > 0) {
                    data.release();
                }
                throw new IOException("Failed to write", e);
            }
        }
    }

    private boolean awaitWriteable() throws IOException {
        if (Context.isOnEventLoopThread()) {
            return this.request.response().writeQueueFull();
        }
        if (this.first) {
            this.first = false;
            return false;
        }
        assert (Thread.holdsLock(this.request.connection()));
        while (this.request.response().writeQueueFull()) {
            if (this.throwable != null) {
                throw new IOException(this.throwable);
            }
            if (this.request.response().closed()) {
                throw new IOException("Connection has been closed");
            }
            this.registerDrainHandler();
            try {
                this.waitingForDrain = true;
                this.request.connection().wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForDrain = false;
            }
        }
        return false;
    }

    private void registerDrainHandler() {
        if (!this.drainHandlerRegistered) {
            this.drainHandlerRegistered = true;
            Handler<Void> handler = new Handler<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(Void event) {
                    HttpConnection connection;
                    HttpConnection httpConnection = connection = ResteasyReactiveOutputStream.this.request.connection();
                    synchronized (httpConnection) {
                        if (ResteasyReactiveOutputStream.this.waitingForDrain) {
                            connection.notifyAll();
                        }
                        if (ResteasyReactiveOutputStream.this.overflow != null && ResteasyReactiveOutputStream.this.overflow.size() > 0) {
                            if (ResteasyReactiveOutputStream.this.closed) {
                                ResteasyReactiveOutputStream.this.request.response().end(Buffer.buffer((byte[])ResteasyReactiveOutputStream.this.overflow.toByteArray()));
                            } else {
                                ResteasyReactiveOutputStream.this.request.response().write((Object)Buffer.buffer((byte[])ResteasyReactiveOutputStream.this.overflow.toByteArray()));
                            }
                            ResteasyReactiveOutputStream.this.overflow.reset();
                        }
                    }
                }
            };
            this.request.response().drainHandler((Handler)handler);
            this.request.response().closeHandler((Handler)handler);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int rem = len;
        int idx = off;
        ByteBuf buffer = this.pooledBuffer;
        try {
            if (buffer == null) {
                this.pooledBuffer = buffer = PooledByteBufAllocator.DEFAULT.directBuffer();
            }
            while (rem > 0) {
                int toWrite = Math.min(rem, buffer.writableBytes());
                buffer.writeBytes(b, idx, toWrite);
                rem -= toWrite;
                idx += toWrite;
                if (buffer.isWritable()) continue;
                ByteBuf tmpBuf = buffer;
                this.pooledBuffer = buffer = PooledByteBufAllocator.DEFAULT.directBuffer();
                this.writeBlocking(tmpBuf, false);
            }
        }
        catch (Exception e) {
            if (buffer != null && buffer.refCnt() > 0) {
                buffer.release();
            }
            throw new IOException(e);
        }
        this.updateWritten(len);
    }

    public void writeBlocking(ByteBuf buffer, boolean finished) throws IOException {
        this.prepareWrite(buffer, finished);
        this.write(buffer, finished);
    }

    private void prepareWrite(ByteBuf buffer, boolean finished) throws IOException {
        if (!this.committed) {
            this.committed = true;
            if (finished) {
                if (buffer == null) {
                    this.context.serverResponse().setResponseHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)"0");
                } else {
                    this.context.serverResponse().setResponseHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)("" + buffer.readableBytes()));
                }
            } else if (!this.request.response().headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                this.request.response().setChunked(true);
            }
        }
        if (finished) {
            this.finished = true;
        }
    }

    void updateWritten(long len) throws IOException {
        this.written += len;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        try {
            if (this.pooledBuffer != null) {
                this.writeBlocking(this.pooledBuffer, false);
                this.pooledBuffer = null;
            }
        }
        catch (Exception e) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.release();
                this.pooledBuffer = null;
            }
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.writeBlocking(this.pooledBuffer, true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.closed = true;
            this.pooledBuffer = null;
        }
    }
}

