/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.vertx;

import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.concurrent.ScheduledFuture;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.ProvidersImpl;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.vertx.ResteasyReactiveOutputStream;
import org.jboss.resteasy.reactive.server.vertx.VertxInputStream;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class VertxResteasyReactiveRequestContext
extends ResteasyReactiveRequestContext
implements ServerHttpRequest,
ServerHttpResponse,
Handler<Void> {
    public static final String CONTINUE = "100-continue";
    protected final RoutingContext context;
    protected final HttpServerRequest request;
    protected final HttpServerResponse response;
    private final Executor contextExecutor;
    protected Consumer<ResteasyReactiveRequestContext> preCommitTask;
    ContinueState continueState = ContinueState.NONE;

    public VertxResteasyReactiveRequestContext(Deployment deployment, ProvidersImpl providers, RoutingContext context, ThreadSetupAction requestContext, ServerRestHandler[] handlerChain, ServerRestHandler[] abortHandlerChain) {
        super(deployment, providers, requestContext, handlerChain, abortHandlerChain);
        this.context = context;
        this.request = context.request();
        this.response = context.response();
        context.addHeadersEndHandler((Handler)this);
        String expect = this.request.getHeader((CharSequence)HttpHeaderNames.EXPECT);
        final ContextInternal internal = ((ConnectionBase)context.request().connection()).getContext();
        if (expect != null && expect.equalsIgnoreCase(CONTINUE)) {
            this.continueState = ContinueState.REQUIRED;
        }
        this.contextExecutor = new Executor(){

            @Override
            public void execute(Runnable command) {
                internal.execute(command);
            }
        };
    }

    public ServerHttpResponse addCloseHandler(final Runnable onClose) {
        this.response.closeHandler((Handler)new Handler<Void>(){

            public void handle(Void v) {
                onClose.run();
            }
        });
        return this;
    }

    public RoutingContext getContext() {
        return this.context;
    }

    public ServerHttpRequest serverRequest() {
        return this;
    }

    public ServerHttpResponse serverResponse() {
        return this;
    }

    protected EventLoop getEventLoop() {
        return ((ConnectionBase)this.context.request().connection()).channel().eventLoop();
    }

    protected Executor getContextExecutor() {
        return this.contextExecutor;
    }

    public Runnable registerTimer(long millis, Runnable task) {
        final ScheduledFuture handle = this.getEventLoop().schedule(task, millis, TimeUnit.MILLISECONDS);
        return new Runnable(){

            @Override
            public void run() {
                handle.cancel(false);
            }
        };
    }

    public String getRequestHeader(CharSequence name) {
        return this.request.headers().get(name);
    }

    public Iterable<Map.Entry<String, String>> getAllRequestHeaders() {
        return this.request.headers();
    }

    public List<String> getAllRequestHeaders(String name) {
        return this.request.headers().getAll(name);
    }

    public boolean containsRequestHeader(CharSequence accept) {
        return this.request.headers().contains(accept);
    }

    public String getRequestPath() {
        return this.request.path();
    }

    public String getRequestMethod() {
        return this.request.method().name();
    }

    public String getRequestNormalisedPath() {
        return this.context.normalisedPath();
    }

    public String getRequestAbsoluteUri() {
        return this.request.absoluteURI();
    }

    public String getRequestScheme() {
        return this.request.scheme();
    }

    public String getRequestHost() {
        return this.request.host();
    }

    public void closeConnection() {
        this.response.close();
    }

    public String getFormAttribute(String name) {
        return this.request.getFormAttribute(name);
    }

    public List<String> getAllFormAttributes(String name) {
        return this.request.formAttributes().getAll(name);
    }

    public String getQueryParam(String name) {
        return this.context.queryParams().get(name);
    }

    public List<String> getAllQueryParams(String name) {
        return this.context.queryParam(name);
    }

    public String query() {
        return this.request.query();
    }

    public Collection<String> queryParamNames() {
        return this.context.queryParams().names();
    }

    public boolean isRequestEnded() {
        return this.request.isEnded();
    }

    public void setExpectMultipart(boolean expectMultipart) {
        this.request.setExpectMultipart(expectMultipart);
    }

    public InputStream createInputStream(ByteBuffer existingData) {
        if (existingData == null) {
            return this.createInputStream();
        }
        return new VertxInputStream(this.context, 10000L, Unpooled.wrappedBuffer((ByteBuffer)existingData), this);
    }

    public InputStream createInputStream() {
        return new VertxInputStream(this.context, 10000L, this);
    }

    public ServerHttpResponse pauseRequestInput() {
        this.request.pause();
        return this;
    }

    public ServerHttpResponse resumeRequestInput() {
        if (this.continueState == ContinueState.REQUIRED) {
            this.continueState = ContinueState.SENT;
            this.response.writeContinue();
        }
        this.request.resume();
        return this;
    }

    public ServerHttpResponse setReadListener(final ServerHttpRequest.ReadCallback callback) {
        this.request.pause();
        if (this.continueState == ContinueState.REQUIRED) {
            this.continueState = ContinueState.SENT;
            this.response.writeContinue();
        }
        this.request.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                callback.data(ByteBuffer.wrap(event.getBytes()));
            }
        });
        this.request.endHandler((Handler)new Handler<Void>(){

            public void handle(Void event) {
                callback.done();
            }
        });
        this.request.resume();
        return this;
    }

    public <T> T unwrap(Class<T> theType) {
        if (theType == RoutingContext.class) {
            return (T)this.context;
        }
        if (theType == HttpServerRequest.class) {
            return (T)this.request;
        }
        if (theType == HttpServerResponse.class) {
            return (T)this.response;
        }
        if (theType == ResteasyReactiveRequestContext.class) {
            return (T)((Object)this);
        }
        return null;
    }

    public ServerHttpResponse setStatusCode(int code) {
        if (!this.response.headWritten()) {
            this.response.setStatusCode(code);
        }
        return this;
    }

    public ServerHttpResponse end() {
        this.response.end();
        return this;
    }

    public boolean headWritten() {
        return this.response.headWritten();
    }

    public ServerHttpResponse end(byte[] data) {
        this.response.end(Buffer.buffer((byte[])data));
        return this;
    }

    public ServerHttpResponse end(String data) {
        this.response.end(data);
        return this;
    }

    public ServerHttpResponse addResponseHeader(CharSequence name, CharSequence value) {
        this.response.headers().add(name, value);
        return this;
    }

    public ServerHttpResponse setResponseHeader(CharSequence name, CharSequence value) {
        this.response.headers().set(name, value);
        return this;
    }

    public ServerHttpResponse setResponseHeader(CharSequence name, Iterable<CharSequence> values) {
        this.response.headers().set(name, values);
        return this;
    }

    public Iterable<Map.Entry<String, String>> getAllResponseHeaders() {
        return this.response.headers();
    }

    public boolean closed() {
        return this.response.closed();
    }

    public ServerHttpResponse setChunked(boolean chunked) {
        this.response.setChunked(chunked);
        return this;
    }

    public ServerHttpResponse write(byte[] data, final Consumer<Throwable> asyncResultHandler) {
        this.response.write((Object)Buffer.buffer((byte[])data), (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> event) {
                if (event.failed()) {
                    asyncResultHandler.accept(event.cause());
                } else {
                    asyncResultHandler.accept(null);
                }
            }
        });
        return this;
    }

    public CompletionStage<Void> write(byte[] data) {
        final CompletableFuture<Void> ret = new CompletableFuture<Void>();
        this.response.write((Object)Buffer.buffer((byte[])data), (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> event) {
                if (event.failed()) {
                    ret.completeExceptionally(event.cause());
                } else {
                    ret.complete(null);
                }
            }
        });
        return ret;
    }

    public ServerHttpResponse sendFile(String path, long offset, long length) {
        this.response.sendFile(path, offset, length);
        return this;
    }

    public OutputStream createResponseOutputStream() {
        return new ResteasyReactiveOutputStream(this);
    }

    public void setPreCommitListener(Consumer<ResteasyReactiveRequestContext> task) {
        this.preCommitTask = task;
    }

    public void handle(Void event) {
        if (this.preCommitTask != null) {
            this.preCommitTask.accept(this);
        }
    }

    public ServerHttpResponse addDrainHandler(final Runnable onDrain) {
        this.response.drainHandler((Handler)new Handler<Void>(){

            public void handle(Void event) {
                onDrain.run();
            }
        });
        return this;
    }

    public boolean isWriteQueueFull() {
        return this.response.writeQueueFull();
    }

    public HttpServerRequest vertxServerRequest() {
        return this.request;
    }

    public HttpServerResponse vertxServerResponse() {
        return this.response;
    }

    static enum ContinueState {
        NONE,
        REQUIRED,
        SENT;

    }
}

