/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.util.RuntimeResourceVisitor;

public class ScoreSystem {
    public static EndpointScores latestScores;
    public static final RuntimeResourceVisitor ScoreVisitor;

    static {
        ScoreVisitor = new RuntimeResourceVisitor(){
            int overallScore = 0;
            int overallTotal = 0;
            List<EndpointScore> endpoints = new ArrayList<EndpointScore>();

            @Override
            public void visitRuntimeResource(String httpMethod, String fullPath, RuntimeResource runtimeResource) {
                ServerMediaType serverMediaType = runtimeResource.getProduces();
                List<MediaType> produces = Collections.emptyList();
                if (serverMediaType != null && serverMediaType.getSortedOriginalMediaTypes() != null && serverMediaType.getSortedOriginalMediaTypes().length >= 1) {
                    produces = Arrays.asList(serverMediaType.getSortedOriginalMediaTypes());
                }
                List<MediaType> consumes = runtimeResource.getConsumes();
                if (runtimeResource.getScore() == null) {
                    return;
                }
                int score = 0;
                int total = 0;
                for (Map.Entry<Category, List<Diagnostic>> scoreEntry : runtimeResource.getScore().entrySet()) {
                    for (Diagnostic diagnostic : scoreEntry.getValue()) {
                        score += diagnostic.score;
                    }
                    total += 100;
                }
                score = (int)Math.floor((float)score / (float)total * 100.0f);
                this.overallScore += score;
                this.overallTotal += 100;
                this.endpoints.add(new EndpointScore(httpMethod, fullPath, produces, consumes, runtimeResource.getScore(), score));
            }

            @Override
            public void visitEnd() {
                if (this.overallScore == 0) {
                    return;
                }
                this.overallScore = (int)Math.floor((float)this.overallScore / (float)this.overallTotal * 100.0f);
                latestScores = new EndpointScores(this.overallScore, this.endpoints);
            }
        };
    }

    public static enum Category {
        Writer,
        Resource,
        Execution;

    }

    public static class Diagnostic {
        public final String message;
        public final int score;
        public static Diagnostic ExecutionNonBlocking = new Diagnostic("Dispatched on the IO thread", 100);
        public static Diagnostic ExecutionBlocking = new Diagnostic("Needs a worker thread dispatch", 0);
        public static Diagnostic ResourceSingleton = new Diagnostic("Single resource instance for all requests", 100);
        public static Diagnostic ResourcePerRequest = new Diagnostic("New resource instance for every request", 0);
        public static Diagnostic WriterRunTime = new Diagnostic("Run time writers required", 0);
        public static Diagnostic WriterNotRequired = new Diagnostic("No writers required", 100);

        public Diagnostic(String message, int percentageScore) {
            this.message = message;
            this.score = percentageScore;
        }

        public String toString() {
            return this.message + ": " + this.score + "/100";
        }

        public static Diagnostic WriterBuildTime(MessageBodyWriter<?> buildTimeWriter) {
            return new Diagnostic("Single writer set at build time: " + buildTimeWriter, 90);
        }

        public static Diagnostic WriterBuildTimeDirect(MessageBodyWriter<?> buildTimeWriter) {
            return new Diagnostic("Single direct writer set at build time: " + buildTimeWriter, 100);
        }

        public static Diagnostic WriterBuildTimeMultiple(List<MessageBodyWriter<?>> buildTimeWriters) {
            return new Diagnostic("Multiple writers set at build time: " + buildTimeWriters, 50);
        }
    }

    public static class EndpointScore {
        public final String httpMethod;
        public final String fullPath;
        public final List<MediaType> produces;
        public final List<MediaType> consumes;
        public final Map<Category, List<Diagnostic>> diagnostics;
        public final int score;

        public EndpointScore(String httpMethod, String fullPath, List<MediaType> produces, List<MediaType> consumes, Map<Category, List<Diagnostic>> diagnostics, int score) {
            this.httpMethod = httpMethod;
            this.fullPath = fullPath;
            this.produces = produces;
            this.consumes = consumes;
            this.diagnostics = diagnostics;
            this.score = score;
        }
    }

    public static class EndpointScores {
        public final List<EndpointScore> endpoints;
        public final int score;

        public EndpointScores(int score, List<EndpointScore> endpoints) {
            this.score = score;
            this.endpoints = endpoints;
        }
    }
}

