/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.ws.rs.NameBinding;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.reactive.common.core.UnmanagedBeanFactory;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.InterceptorContainer;
import org.jboss.resteasy.reactive.common.model.PreMatchInterceptorContainer;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.SettableResourceInterceptor;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class FeatureContextImpl
implements FeatureContext {
    protected final ResourceInterceptors interceptors;
    private final ExceptionMapping exceptionMapping;
    private final Function<Class<?>, BeanFactory<?>> beanFactoryCreator;
    private final ConfigurationImpl configuration;
    private boolean filtersNeedSorting = false;

    public FeatureContextImpl(ResourceInterceptors interceptors, ExceptionMapping exceptionMapping, ConfigurationImpl configuration, Function<Class<?>, BeanFactory<?>> beanFactoryCreator) {
        this.interceptors = interceptors;
        this.exceptionMapping = exceptionMapping;
        this.configuration = configuration;
        this.beanFactoryCreator = beanFactoryCreator;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public FeatureContext property(String name, Object value) {
        this.configuration.property(name, value);
        return this;
    }

    public FeatureContext register(Class<?> componentClass) {
        this.doRegister(componentClass, null, null);
        return this;
    }

    public FeatureContext register(Class<?> componentClass, int priority) {
        this.doRegister(componentClass, null, priority);
        return this;
    }

    public FeatureContext register(Class<?> componentClass, Class<?> ... contracts) {
        throw new UnsupportedOperationException();
    }

    public FeatureContext register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        throw new UnsupportedOperationException();
    }

    public FeatureContext register(Object component) {
        this.doRegister(component.getClass(), (BeanFactory<?>)new UnmanagedBeanFactory(component), null);
        return this;
    }

    public FeatureContext register(Object component, int priority) {
        this.doRegister(component.getClass(), (BeanFactory<?>)new UnmanagedBeanFactory(component), priority);
        return this;
    }

    public FeatureContext register(Object component, Class<?> ... contracts) {
        throw new UnsupportedOperationException();
    }

    public FeatureContext register(Object component, Map<Class<?>, Integer> contracts) {
        throw new UnsupportedOperationException();
    }

    private void doRegister(Class<?> componentClass, BeanFactory<?> beanFactory, Integer priority) {
        if (!this.isAllowed(componentClass)) {
            return;
        }
        if (ExceptionMapper.class.isAssignableFrom(componentClass)) {
            Type[] genericInterfaces;
            for (Type type : genericInterfaces = componentClass.getGenericInterfaces()) {
                Type exceptionType;
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)type).getRawType().equals(ExceptionMapper.class) || !((exceptionType = parameterizedType.getActualTypeArguments()[0]) instanceof Class)) continue;
                Class exceptionClass = (Class)exceptionType;
                ResourceExceptionMapper resourceExceptionMapper = new ResourceExceptionMapper();
                resourceExceptionMapper.setFactory(this.getFactory(componentClass, beanFactory));
                this.exceptionMapping.addExceptionMapper(exceptionClass, resourceExceptionMapper);
                break;
            }
        }
        if (this.isFilter(componentClass)) {
            this.registerFilters(componentClass, beanFactory, priority);
            this.filtersNeedSorting = true;
        }
        if (this.isInterceptor(componentClass)) {
            this.registerInterceptors(componentClass, beanFactory, priority);
            this.filtersNeedSorting = true;
        }
    }

    protected boolean isFilter(Class<?> componentClass) {
        return ContainerRequestFilter.class.isAssignableFrom(componentClass) || ContainerResponseFilter.class.isAssignableFrom(componentClass);
    }

    protected void registerFilters(Class<?> componentClass, BeanFactory<?> beanFactory, Integer priority) {
        boolean isRequest = ContainerRequestFilter.class.isAssignableFrom(componentClass);
        boolean isResponse = ContainerResponseFilter.class.isAssignableFrom(componentClass);
        if (isRequest) {
            this.register(componentClass, beanFactory, priority, (InterceptorContainer)this.interceptors.getContainerRequestFilters());
        }
        if (isResponse) {
            this.register(componentClass, beanFactory, priority, this.interceptors.getContainerResponseFilters());
        }
    }

    protected boolean isInterceptor(Class<?> componentClass) {
        return ReaderInterceptor.class.isAssignableFrom(componentClass) || WriterInterceptor.class.isAssignableFrom(componentClass);
    }

    protected void registerInterceptors(Class<?> componentClass, BeanFactory<?> beanFactory, Integer priority) {
        boolean isReader = ReaderInterceptor.class.isAssignableFrom(componentClass);
        boolean isWriter = WriterInterceptor.class.isAssignableFrom(componentClass);
        if (isReader) {
            this.register(componentClass, beanFactory, priority, this.interceptors.getReaderInterceptors());
        }
        if (isWriter) {
            this.register(componentClass, beanFactory, priority, this.interceptors.getWriterInterceptors());
        }
    }

    private <T> void register(Class<?> componentClass, BeanFactory<?> beanFactory, Integer priority, InterceptorContainer<T> interceptorContainer) {
        ResourceInterceptor interceptor = interceptorContainer.create();
        Set<String> nameBindings = this.setCommonFilterProperties(componentClass, beanFactory, priority, (SettableResourceInterceptor)interceptor);
        if (interceptorContainer instanceof PreMatchInterceptorContainer && componentClass.isAnnotationPresent(PreMatching.class)) {
            ((PreMatchInterceptorContainer)interceptorContainer).addPreMatchInterceptor(interceptor);
        } else if (nameBindings.isEmpty()) {
            interceptorContainer.addGlobalRequestInterceptor(interceptor);
        } else {
            interceptorContainer.addNameRequestInterceptor(interceptor);
        }
    }

    protected boolean isAllowed(Class<?> componentClass) {
        return true;
    }

    private Set<String> setCommonFilterProperties(Class<?> componentClass, BeanFactory<?> beanFactory, Integer priority, SettableResourceInterceptor interceptor) {
        Annotation[] annotations;
        interceptor.setFactory(this.getFactory(componentClass, beanFactory));
        this.setFilterPriority(componentClass, priority, interceptor);
        HashSet<String> nameBindings = new HashSet<String>();
        for (Annotation annotation : annotations = componentClass.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotation() || !annotation.annotationType().isAnnotationPresent(NameBinding.class)) continue;
            nameBindings.add(annotation.annotationType().getName());
        }
        if (!nameBindings.isEmpty()) {
            interceptor.setNameBindingNames(nameBindings);
        }
        return nameBindings;
    }

    protected void setFilterPriority(Class<?> componentClass, Integer priority, SettableResourceInterceptor interceptor) {
        if (priority == null) {
            if (componentClass.isAnnotationPresent(Priority.class)) {
                interceptor.setPriority(Integer.valueOf(componentClass.getDeclaredAnnotation(Priority.class).value()));
            }
        } else {
            interceptor.setPriority(priority);
        }
    }

    protected BeanFactory getFactory(Class<?> componentClass, BeanFactory explicitValue) {
        if (explicitValue != null) {
            return explicitValue;
        }
        return this.beanFactoryCreator.apply(componentClass);
    }

    public boolean isFiltersNeedSorting() {
        return this.filtersNeedSorting;
    }
}

