/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.reactive.common.util.PathSegmentImpl;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.common.util.URIDecoder;
import org.jboss.resteasy.reactive.common.util.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.UriMatch;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;

public class UriInfoImpl
implements UriInfo {
    private final ResteasyReactiveRequestContext currentRequest;
    private MultivaluedMap<String, String> queryParams;
    private MultivaluedMap<String, String> pathParams;
    private URI requestUri;

    public UriInfoImpl(ResteasyReactiveRequestContext currentRequest) {
        this.currentRequest = currentRequest;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        String path = URIDecoder.decodeURIComponent((String)this.currentRequest.getPath(), (boolean)false);
        String prefix = this.currentRequest.getDeployment().getPrefix();
        if (prefix.isEmpty()) {
            return path;
        }
        return path.substring(prefix.length());
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        return PathSegmentImpl.parseSegments((String)this.getPath(), (boolean)decode);
    }

    public URI getRequestUri() {
        if (this.requestUri == null) {
            ServerHttpRequest request = this.currentRequest.serverRequest();
            try {
                this.requestUri = new URI(this.currentRequest.getAbsoluteURI()).normalize();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.requestUri;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    public URI getAbsolutePath() {
        try {
            return new URI(this.currentRequest.getAbsoluteURI()).normalize();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    public URI getBaseUri() {
        try {
            Deployment deployment = this.currentRequest.getDeployment();
            String prefix = "/";
            if (deployment != null) {
                prefix = deployment.getPrefix();
                prefix = prefix.isEmpty() ? "/" : prefix + "/";
            }
            return new URI(this.currentRequest.getScheme(), this.currentRequest.getAuthority(), prefix, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        if (this.pathParams == null) {
            this.pathParams = new QuarkusMultivaluedHashMap();
            for (Map.Entry<String, Integer> pathParam : this.currentRequest.getTarget().getPathParameterIndexes().entrySet()) {
                this.pathParams.add((Object)pathParam.getKey(), (Object)this.currentRequest.getPathParam(pathParam.getValue()));
            }
        }
        return new UnmodifiableMultivaluedMap(this.pathParams);
    }

    private RuntimeException encodedNotSupported() {
        return new IllegalArgumentException("We do not support non-decoded parameters");
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        if (this.queryParams == null) {
            this.queryParams = new QuarkusMultivaluedHashMap();
            Collection<String> entries = this.currentRequest.serverRequest().queryParamNames();
            for (String i : entries) {
                this.queryParams.addAll((Object)i, this.currentRequest.serverRequest().getAllQueryParams(i));
            }
        }
        return new UnmodifiableMultivaluedMap(this.queryParams);
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        if (this.currentRequest.getTarget() == null) {
            return Collections.emptyList();
        }
        List<UriMatch> oldMatches = this.currentRequest.getMatchedURIs();
        ArrayList<String> matched = new ArrayList<String>();
        String last = null;
        for (int i = 0; i < oldMatches.size(); ++i) {
            String m = oldMatches.get((int)i).matched;
            if (m.equals(last)) continue;
            matched.add(m);
            last = m;
        }
        return matched;
    }

    public List<Object> getMatchedResources() {
        List<UriMatch> oldMatches = this.currentRequest.getMatchedURIs();
        ArrayList<Object> matched = new ArrayList<Object>();
        for (int i = 0; i < oldMatches.size(); ++i) {
            Object target = oldMatches.get((int)i).target;
            if (target == null) continue;
            matched.add(target);
        }
        return matched;
    }

    public URI resolve(URI uri) {
        return null;
    }

    public URI relativize(URI uri) {
        return null;
    }
}

