/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.LazyResponse;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.ResponseBuilderImpl;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ResponseHandler
implements ServerRestHandler {
    @Override
    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        final Object result = requestContext.getResult();
        if (result instanceof Response) {
            Response.ResponseBuilder responseBuilder;
            boolean mediaTypeAlreadyExists = false;
            Response existing = (Response)result;
            if (existing.getEntity() instanceof GenericEntity) {
                GenericEntity genericEntity = (GenericEntity)existing.getEntity();
                requestContext.setGenericReturnType(genericEntity.getType());
                responseBuilder = Response.fromResponse((Response)existing).entity(genericEntity.getEntity());
            } else {
                ResponseImpl responseImpl;
                if (existing.hasEntity()) {
                    requestContext.setGenericReturnType(existing.getEntity().getClass());
                }
                responseBuilder = Response.fromResponse((Response)((Response)result));
                if (result instanceof ResponseImpl && (responseImpl = (ResponseImpl)result).getEntityAnnotations() != null) {
                    requestContext.setAdditionalAnnotations(responseImpl.getEntityAnnotations());
                }
            }
            if (existing.getMediaType() != null) {
                requestContext.setResponseContentType(existing.getMediaType());
                mediaTypeAlreadyExists = true;
            }
            EncodedMediaType produces = requestContext.getResponseContentType();
            if (!mediaTypeAlreadyExists && produces != null) {
                responseBuilder.header("Content-Type", (Object)produces.toString());
            }
            if (responseBuilder instanceof ResponseBuilderImpl) {
                requestContext.setResponse(new LazyResponse.Existing((Response)((ResponseBuilderImpl)responseBuilder).build(false)));
            } else {
                requestContext.setResponse(new LazyResponse.Existing(responseBuilder.build()));
            }
        } else {
            requestContext.setResponse(new LazyResponse(){
                Response response;

                @Override
                public Response get() {
                    if (this.response == null) {
                        Response.ResponseBuilder responseBuilder;
                        if (result instanceof GenericEntity) {
                            GenericEntity genericEntity = (GenericEntity)result;
                            requestContext.setGenericReturnType(genericEntity.getType());
                            responseBuilder = ResponseImpl.ok((Object)genericEntity.getEntity());
                        } else {
                            responseBuilder = result == null ? ResponseImpl.noContent() : ResponseImpl.ok((Object)result);
                        }
                        EncodedMediaType produces = requestContext.getResponseContentType();
                        if (produces != null) {
                            responseBuilder.header("Content-Type", (Object)produces.toString());
                        }
                        this.response = responseBuilder instanceof ResponseBuilderImpl ? ((ResponseBuilderImpl)responseBuilder).build(false) : responseBuilder.build();
                    }
                    return this.response;
                }

                @Override
                public boolean isCreated() {
                    return this.response != null;
                }
            });
        }
    }
}

