/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import org.jboss.resteasy.reactive.common.model.ResourceContextResolver;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.server.jaxrs.ContextResolverDelegate;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ContextResolvers {
    private final Map<Class<?>, List<ResourceContextResolver>> resolvers = new HashMap();

    public <T> void addContextResolver(Class<T> contextType, ResourceContextResolver contextResolver) {
        List<ResourceContextResolver> list = this.resolvers.get(contextType);
        if (list == null) {
            list = new ArrayList<ResourceContextResolver>(1);
            this.resolvers.put(contextType, list);
        }
        list.add(contextResolver);
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> clazz, MediaType mediaType) {
        List<ResourceContextResolver> goodResolvers = this.resolvers.get(clazz);
        if (goodResolvers != null && !goodResolvers.isEmpty()) {
            List<MediaType> mt = Collections.singletonList(mediaType);
            ArrayList delegates = new ArrayList();
            MediaType bestMatch = null;
            for (ResourceContextResolver goodResolver : goodResolvers) {
                boolean add = false;
                if (mediaType == null) {
                    add = true;
                } else {
                    MediaType match;
                    if (goodResolver.mediaTypes().isEmpty()) {
                        match = MediaType.WILDCARD_TYPE;
                    } else {
                        match = MediaTypeHelper.getBestMatch(mt, (List)goodResolver.mediaTypes());
                        if (match == null) continue;
                    }
                    if (bestMatch == null) {
                        bestMatch = match;
                        add = true;
                    } else {
                        int cmp = MediaTypeHelper.COMPARATOR.compare(bestMatch, match);
                        if (cmp == 0) {
                            add = true;
                        } else if (cmp > 0) {
                            delegates.clear();
                            add = true;
                            bestMatch = match;
                        }
                    }
                }
                if (!add) continue;
                delegates.add((ContextResolver)goodResolver.getFactory().createInstance().getInstance());
            }
            if (delegates.isEmpty()) {
                return null;
            }
            if (delegates.size() == 1) {
                return (ContextResolver)delegates.get(0);
            }
            return new ContextResolverDelegate(delegates);
        }
        return null;
    }

    public Map<Class<?>, List<ResourceContextResolver>> getResolvers() {
        return this.resolvers;
    }

    public void initializeDefaultFactories(Function<String, BeanFactory<?>> factoryCreator) {
        for (Map.Entry<Class<?>, List<ResourceContextResolver>> entry : this.resolvers.entrySet()) {
            for (ResourceContextResolver i : entry.getValue()) {
                if (i.getFactory() != null) continue;
                i.setFactory(factoryCreator.apply(i.getClassName()));
            }
        }
    }
}

