/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class FormBodyHandler
implements ServerRestHandler {
    private static final byte[] NO_BYTES = new byte[0];
    private final boolean alsoSetInputStream;

    public FormBodyHandler(boolean alsoSetInputStream) {
        this.alsoSetInputStream = alsoSetInputStream;
    }

    @Override
    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        if (requestContext.hasInputStream()) {
            return;
        }
        ServerHttpRequest serverHttpRequest = requestContext.serverRequest();
        if (serverHttpRequest.isRequestEnded()) {
            if (this.alsoSetInputStream) {
                requestContext.setInputStream(new ByteArrayInputStream(NO_BYTES));
            }
        } else {
            serverHttpRequest.setExpectMultipart(true);
            requestContext.suspend();
            final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            serverHttpRequest.setReadListener(new ServerHttpRequest.ReadCallback(){

                @Override
                public void done() {
                    requestContext.setInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
                    requestContext.resume();
                }

                @Override
                public void data(ByteBuffer data) {
                    byte[] buf = new byte[data.remaining()];
                    data.get(buf);
                    try {
                        outputStream.write(buf);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

