/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.jaxrs.ReaderInterceptorContextImpl;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class RequestDeserializeHandler
implements ServerRestHandler {
    private static final Logger log = Logger.getLogger(RequestDeserializeHandler.class);
    private final Class<?> type;
    private final Type genericType;
    private final MediaType mediaType;
    private final ServerSerialisers serialisers;
    private final int parameterIndex;

    public RequestDeserializeHandler(Class<?> type, Type genericType, MediaType mediaType, ServerSerialisers serialisers, int parameterIndex) {
        this.type = type;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.serialisers = serialisers;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        MediaType effectiveRequestType = this.mediaType;
        String requestTypeString = requestContext.serverRequest().getRequestHeader("Content-Type");
        if (requestTypeString != null) {
            try {
                effectiveRequestType = MediaType.valueOf((String)requestTypeString);
            }
            catch (Exception e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            }
        } else if (effectiveRequestType == null) {
            effectiveRequestType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        List readers = this.serialisers.findReaders(null, this.type, effectiveRequestType, RuntimeType.SERVER);
        if (readers.isEmpty()) {
            throw new NotSupportedException();
        }
        for (MessageBodyReader reader : readers) {
            Object result;
            if (!this.isReadable(reader, requestContext, effectiveRequestType)) continue;
            ReaderInterceptor[] interceptors = requestContext.getReaderInterceptors();
            try {
                try {
                    result = interceptors == null ? this.readFrom(reader, requestContext, effectiveRequestType) : new ReaderInterceptorContextImpl(requestContext, this.getAnnotations(requestContext), this.type, this.genericType, effectiveRequestType, reader, requestContext.getInputStream(), interceptors, this.serialisers).proceed();
                }
                catch (NoContentException e) {
                    throw new BadRequestException((Throwable)e);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error occurred during deserialization of input", (Throwable)e);
                requestContext.handleException(e, true);
                requestContext.resume();
                return;
            }
            requestContext.setRequestEntity(result);
            requestContext.resume();
            return;
        }
        throw new NotSupportedException("No supported MessageBodyReader found");
    }

    private boolean isReadable(MessageBodyReader<?> reader, ResteasyReactiveRequestContext requestContext, MediaType requestType) {
        if (reader instanceof ServerMessageBodyReader) {
            return ((ServerMessageBodyReader)reader).isReadable(this.type, this.genericType, requestContext.getTarget().getLazyMethod(), requestType);
        }
        return reader.isReadable(this.type, this.genericType, this.getAnnotations(requestContext), requestType);
    }

    public Object readFrom(MessageBodyReader<?> reader, ResteasyReactiveRequestContext requestContext, MediaType requestType) throws IOException {
        requestContext.requireCDIRequestScope();
        if (reader instanceof ServerMessageBodyReader) {
            return ((ServerMessageBodyReader)reader).readFrom(this.type, this.genericType, requestType, requestContext);
        }
        return reader.readFrom(this.type, this.genericType, this.getAnnotations(requestContext), requestType, requestContext.getHttpHeaders().getRequestHeaders(), requestContext.getInputStream());
    }

    private Annotation[] getAnnotations(ResteasyReactiveRequestContext requestContext) {
        return requestContext.getTarget().getLazyMethod().getParameterAnnotations(this.parameterIndex);
    }
}

