/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.util.function.Function;
import javax.ws.rs.container.CompletionCallback;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionTarget;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class PerRequestInstanceHandler
implements ServerRestHandler {
    private final BeanFactory<Object> factory;
    private final Function<Object, Object> clientProxyUnwrapper;

    public PerRequestInstanceHandler(BeanFactory<Object> factory, Function<Object, Object> clientProxyUnwrapper) {
        this.factory = factory;
        this.clientProxyUnwrapper = clientProxyUnwrapper;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        requestContext.requireCDIRequestScope();
        final BeanFactory.BeanInstance instance = this.factory.createInstance();
        requestContext.setEndpointInstance(instance.getInstance());
        Object unwrapped = instance.getInstance();
        if (this.clientProxyUnwrapper != null) {
            unwrapped = this.clientProxyUnwrapper.apply(unwrapped);
        }
        ((ResteasyReactiveInjectionTarget)unwrapped).__quarkus_rest_inject(requestContext);
        requestContext.registerCompletionCallback(new CompletionCallback(){

            public void onComplete(Throwable throwable) {
                instance.close();
            }
        });
    }
}

