/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.startup;

import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.types.AllWriteableMarker;
import org.jboss.resteasy.reactive.common.util.DeploymentUtils;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.common.util.types.TypeSignatureParser;
import org.jboss.resteasy.reactive.common.util.types.Types;
import org.jboss.resteasy.reactive.multipart.FileUpload;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.parameters.AsyncResponseExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.BodyParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.ContextParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.CookieParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.FormParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.HeaderParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.InjectParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.LocatableResourcePathParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.MatrixParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.MultipartFormParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.NullParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.PathParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.QueryParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.core.serialization.DynamicEntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriterArray;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeInterceptorDeployment;
import org.jboss.resteasy.reactive.server.handlers.AbortChainHandler;
import org.jboss.resteasy.reactive.server.handlers.BlockingHandler;
import org.jboss.resteasy.reactive.server.handlers.ExceptionHandler;
import org.jboss.resteasy.reactive.server.handlers.FixedProducesHandler;
import org.jboss.resteasy.reactive.server.handlers.FormBodyHandler;
import org.jboss.resteasy.reactive.server.handlers.InputHandler;
import org.jboss.resteasy.reactive.server.handlers.InstanceHandler;
import org.jboss.resteasy.reactive.server.handlers.InvocationHandler;
import org.jboss.resteasy.reactive.server.handlers.NonBlockingHandler;
import org.jboss.resteasy.reactive.server.handlers.ParameterHandler;
import org.jboss.resteasy.reactive.server.handlers.PerRequestInstanceHandler;
import org.jboss.resteasy.reactive.server.handlers.PublisherResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.RequestDeserializeHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceLocatorHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceRequestFilterHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.SseResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.VariableProducesHandler;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.model.ServerMethodParameter;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.util.ScoreSystem;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class RuntimeResourceDeployment {
    private static final ServerRestHandler[] EMPTY_REST_HANDLER_ARRAY = new ServerRestHandler[0];
    private static final MessageBodyWriter[] EMPTY_MESSAGE_BODY_WRITERS = new MessageBodyWriter[0];
    private static final int HANDLERS_CAPACITY = 10;
    private static final Logger log = Logger.getLogger(RuntimeResourceDeployment.class);
    private final DeploymentInfo info;
    private final ServerSerialisers serialisers;
    private final ResteasyReactiveConfig resteasyReactiveConfig;
    private final Supplier<Executor> executorSupplier;
    private final Supplier<Executor> virtualExecutorSupplier;
    private final RuntimeInterceptorDeployment runtimeInterceptorDeployment;
    private final DynamicEntityWriter dynamicEntityWriter;
    private final ResourceLocatorHandler resourceLocatorHandler;
    private final boolean defaultBlocking;
    private final BlockingHandler blockingHandler;
    private final BlockingHandler blockingHandlerVirtualThread;
    private final ResponseWriterHandler responseWriterHandler;

    public RuntimeResourceDeployment(DeploymentInfo info, Supplier<Executor> executorSupplier, Supplier<Executor> virtualExecutorSupplier, RuntimeInterceptorDeployment runtimeInterceptorDeployment, DynamicEntityWriter dynamicEntityWriter, ResourceLocatorHandler resourceLocatorHandler, boolean defaultBlocking) {
        this.info = info;
        this.serialisers = info.getSerialisers();
        this.resteasyReactiveConfig = info.getResteasyReactiveConfig();
        this.executorSupplier = executorSupplier;
        this.virtualExecutorSupplier = virtualExecutorSupplier;
        this.runtimeInterceptorDeployment = runtimeInterceptorDeployment;
        this.dynamicEntityWriter = dynamicEntityWriter;
        this.resourceLocatorHandler = resourceLocatorHandler;
        this.defaultBlocking = defaultBlocking;
        this.blockingHandler = new BlockingHandler(executorSupplier);
        this.blockingHandlerVirtualThread = new BlockingHandler(virtualExecutorSupplier);
        this.responseWriterHandler = new ResponseWriterHandler(dynamicEntityWriter);
    }

    public RuntimeResource buildResourceMethod(ResourceClass clazz, ServerResourceMethod method, boolean locatableResource, URITemplate classPathTemplate, DeploymentInfo info) {
        List responseFilterHandlers;
        int i;
        Set<String> classAnnotationNames;
        List<MediaType> consumesMediaTypes;
        URITemplate methodPathTemplate = new URITemplate(method.getPath(), method.isResourceLocator());
        QuarkusMultivaluedHashMap score = new QuarkusMultivaluedHashMap();
        Map<String, Integer> pathParameterIndexes = this.buildParamIndexMap(classPathTemplate, methodPathTemplate);
        MediaType streamElementType = null;
        if (method.getStreamElementType() != null) {
            streamElementType = MediaType.valueOf((String)method.getStreamElementType());
        }
        if (method.getConsumes() == null) {
            consumesMediaTypes = Collections.emptyList();
        } else {
            consumesMediaTypes = new ArrayList(method.getConsumes().length);
            for (String s : method.getConsumes()) {
                consumesMediaTypes.add(MediaType.valueOf((String)s));
            }
        }
        Class resourceClass = DeploymentUtils.loadClass((String)clazz.getClassName());
        Class[] parameterDeclaredTypes = new Class[method.getParameters().length];
        Class[] parameterDeclaredUnresolvedTypes = new Class[method.getParameters().length];
        for (int i2 = 0; i2 < method.getParameters().length; ++i2) {
            MethodParameter parameter = method.getParameters()[i2];
            Annotation[] declaredType = parameter.declaredType;
            String declaredUnresolvedType = parameter.declaredUnresolvedType;
            parameterDeclaredTypes[i2] = DeploymentUtils.loadClass((String)declaredType);
            parameterDeclaredUnresolvedTypes[i2] = parameterDeclaredTypes[i2];
            if (declaredType.equals(declaredUnresolvedType)) continue;
            parameterDeclaredUnresolvedTypes[i2] = DeploymentUtils.loadClass((String)declaredUnresolvedType);
        }
        Annotation[] resourceClassAnnotations = resourceClass.getAnnotations();
        if (resourceClassAnnotations.length == 0) {
            classAnnotationNames = Collections.emptySet();
        } else {
            classAnnotationNames = new HashSet(resourceClassAnnotations.length);
            for (Annotation annotation : resourceClassAnnotations) {
                classAnnotationNames.add(annotation.annotationType().getName());
            }
        }
        ResteasyReactiveResourceInfo lazyMethod = new ResteasyReactiveResourceInfo(method.getName(), resourceClass, parameterDeclaredUnresolvedTypes, classAnnotationNames, method.getMethodAnnotationNames(), !this.defaultBlocking && !method.isBlocking());
        RuntimeInterceptorDeployment.MethodInterceptorContext interceptorDeployment = this.runtimeInterceptorDeployment.forMethod(method, lazyMethod);
        ServerRestHandler interceptorHandler = interceptorDeployment.setupInterceptorHandler();
        ArrayList<ServerRestHandler> abortHandlingChain = new ArrayList<ServerRestHandler>(3 + (interceptorHandler != null ? 1 : 0));
        ArrayList<ServerRestHandler> handlers = new ArrayList<ServerRestHandler>(10);
        handlers.add(null);
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_MATCH);
        if (interceptorHandler != null) {
            handlers.add(interceptorHandler);
        }
        Optional<Object> blockingHandlerIndex = Optional.empty();
        if (!this.defaultBlocking) {
            if (method.isBlocking()) {
                if (method.isRunOnVirtualThread()) {
                    handlers.add(this.blockingHandlerVirtualThread);
                } else {
                    handlers.add(this.blockingHandler);
                }
                blockingHandlerIndex = Optional.of(handlers.size() - 1);
                score.add((Object)ScoreSystem.Category.Execution, (Object)ScoreSystem.Diagnostic.ExecutionBlocking);
            } else {
                if (method.isRunOnVirtualThread()) {
                    log.error((Object)"a method was both non blocking and @RunOnVirtualThread, it is now considered @RunOnVirtual and blocking");
                    handlers.add(this.blockingHandlerVirtualThread);
                } else {
                    handlers.add(NonBlockingHandler.INSTANCE);
                }
                score.add((Object)ScoreSystem.Category.Execution, (Object)ScoreSystem.Diagnostic.ExecutionNonBlocking);
            }
        }
        if (method.getReturnType().equals("Lio/vertx/core/file/AsyncFile;") && interceptorDeployment.hasWriterInterceptors()) {
            throw new RuntimeException("Endpoints that return an AsyncFile cannot have any WriterInterceptor set");
        }
        boolean hasWithFormReadRequestFilters = false;
        if (method.getHttpMethod() != null) {
            List<ResourceRequestFilterHandler> containerRequestFilterHandlers = interceptorDeployment.setupRequestFilterHandler();
            if (blockingHandlerIndex.isPresent()) {
                int initialIndex = (Integer)blockingHandlerIndex.get();
                for (int i3 = 0; i3 < containerRequestFilterHandlers.size(); ++i3) {
                    ResourceRequestFilterHandler handler = containerRequestFilterHandlers.get(i3);
                    if (handler.isNonBlockingRequired()) {
                        handlers.add(initialIndex + i3, handler);
                        continue;
                    }
                    handlers.add(handler);
                }
            } else {
                handlers.addAll(containerRequestFilterHandlers);
            }
            for (ResourceRequestFilterHandler handler : containerRequestFilterHandlers) {
                if (!handler.isWithFormRead()) continue;
                hasWithFormReadRequestFilters = true;
            }
        }
        MethodParameter[] parameters = method.getParameters();
        MethodParameter bodyParameter = null;
        int bodyParameterIndex = -1;
        for (int i4 = 0; i4 < parameters.length; ++i4) {
            MethodParameter param = parameters[i4];
            if (param.parameterType != ParameterType.BODY) continue;
            bodyParameter = param;
            bodyParameterIndex = i4;
            break;
        }
        boolean checkWithFormReadRequestFilters = false;
        if (method.isFormParamRequired() || hasWithFormReadRequestFilters) {
            handlers.add(new FormBodyHandler(bodyParameter != null, this.executorSupplier, method.getFileFormNames()));
            checkWithFormReadRequestFilters = true;
        } else if (bodyParameter != null && !this.defaultBlocking && !method.isBlocking()) {
            handlers.add(new InputHandler(this.resteasyReactiveConfig.getInputBufferSize(), this.executorSupplier));
            checkWithFormReadRequestFilters = true;
        }
        if (checkWithFormReadRequestFilters && hasWithFormReadRequestFilters) {
            ArrayList<ServerRestHandler> readBodyRequestFilters = new ArrayList<ServerRestHandler>(1);
            for (i = handlers.size() - 2; i >= 0; --i) {
                ResourceRequestFilterHandler resourceRequestFilterHandler;
                ServerRestHandler serverRestHandler = (ServerRestHandler)handlers.get(i);
                if (!(serverRestHandler instanceof ResourceRequestFilterHandler) || !(resourceRequestFilterHandler = (ResourceRequestFilterHandler)serverRestHandler).isWithFormRead()) continue;
                readBodyRequestFilters.add((ServerRestHandler)handlers.remove(i));
            }
            handlers.addAll(readBodyRequestFilters);
        }
        if (bodyParameter != null) {
            Class typeClass;
            Type genericType = typeClass = DeploymentUtils.loadClass((String)bodyParameter.declaredType);
            if (!bodyParameter.type.equals(bodyParameter.declaredType)) {
                genericType = TypeSignatureParser.parse((String)bodyParameter.signature);
            }
            handlers.add(new RequestDeserializeHandler(typeClass, genericType, consumesMediaTypes, this.serialisers, bodyParameterIndex));
        }
        ServerRestHandler instanceHandler = null;
        if (!locatableResource) {
            if (clazz.isPerRequestResource()) {
                instanceHandler = new PerRequestInstanceHandler((BeanFactory<Object>)clazz.getFactory(), info.getClientProxyUnwrapper());
                score.add((Object)ScoreSystem.Category.Resource, (Object)ScoreSystem.Diagnostic.ResourcePerRequest);
            } else {
                instanceHandler = new InstanceHandler((BeanFactory<Object>)clazz.getFactory());
                score.add((Object)ScoreSystem.Category.Resource, (Object)ScoreSystem.Diagnostic.ResourceSingleton);
            }
            handlers.add(instanceHandler);
        }
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.RESOLVE_METHOD_PARAMETERS);
        for (i = 0; i < parameters.length; ++i) {
            boolean userProviderConvertersExist;
            ServerMethodParameter param = (ServerMethodParameter)parameters[i];
            ParameterExtractor extractor = this.parameterExtractor(pathParameterIndexes, locatableResource, param);
            ParameterConverter converter = null;
            ParamConverterProviders paramConverterProviders = info.getParamConverterProviders();
            boolean bl = userProviderConvertersExist = !paramConverterProviders.getParamConverterProviders().isEmpty();
            if (param.converter != null) {
                converter = (ParameterConverter)param.converter.get();
                if (userProviderConvertersExist) {
                    Method javaMethod = lazyMethod.getMethod();
                    Class<?>[] parameterTypes = javaMethod.getParameterTypes();
                    Type[] genericParameterTypes = javaMethod.getGenericParameterTypes();
                    Annotation[][] parameterAnnotations = javaMethod.getParameterAnnotations();
                    RuntimeResourceDeployment.smartInitParameterConverter(i, converter, paramConverterProviders, parameterTypes, genericParameterTypes, parameterAnnotations);
                    converter = new RuntimeResolvedConverter(converter);
                    converter.init(paramConverterProviders, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i]);
                }
            }
            handlers.add(new ParameterHandler(i, param.getDefaultValue(), extractor, converter, param.parameterType, param.isObtainedAsCollection(), param.isOptional()));
        }
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.BEFORE_METHOD_INVOKE);
        EndpointInvoker invoker = method.getInvoker().get();
        ServerRestHandler alternate = this.alternateInvoker(method, invoker);
        if (alternate != null) {
            handlers.add(alternate);
        } else {
            handlers.add(new InvocationHandler(invoker));
        }
        boolean afterMethodInvokeHandlersAdded = this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE);
        boolean afterMethodInvokeHandlersSecondRoundAdded = this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE_SECOND_ROUND);
        if (afterMethodInvokeHandlersAdded || afterMethodInvokeHandlersSecondRoundAdded) {
            this.addStreamingResponseCustomizers(method, handlers);
        }
        Type returnType = TypeSignatureParser.parse((String)method.getReturnType());
        Type effectiveReturnType = Types.getEffectiveReturnType((Type)returnType);
        Class rawEffectiveReturnType = Types.getRawType((Type)effectiveReturnType);
        ServerMediaType serverMediaType = null;
        if (method.getProduces() != null && method.getProduces().length > 0) {
            serverMediaType = new ServerMediaType(ServerMediaType.mediaTypesFromArray((String[])method.getProduces()), StandardCharsets.UTF_8.name(), false);
        }
        if (method.getHttpMethod() == null) {
            handlers.add(this.resourceLocatorHandler);
        } else if (!Response.class.isAssignableFrom(rawEffectiveReturnType)) {
            if (method.getProduces() != null && method.getProduces().length > 0) {
                if (method.getProduces().length == 1) {
                    MediaType mediaType = MediaType.valueOf((String)method.getProduces()[0]);
                    if (mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
                        handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                        score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                    } else if (RuntimeResourceDeployment.isNotVoid(rawEffectiveReturnType)) {
                        List buildTimeWriters = this.serialisers.findBuildTimeWriters(rawEffectiveReturnType, RuntimeType.SERVER, MediaTypeHelper.toListOfMediaType((String[])method.getProduces()));
                        if (buildTimeWriters == null) {
                            handlers.add(new FixedProducesHandler(mediaType, this.dynamicEntityWriter));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                        } else if (buildTimeWriters.isEmpty()) {
                            log.warn((Object)("Cannot find any combination of response writers for the method " + clazz.getClassName() + "#" + method.getName() + "(" + Arrays.toString(method.getParameters()) + ")"));
                            handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                        } else if (this.isSingleEffectiveWriter(buildTimeWriters)) {
                            MessageBodyWriter writer = (MessageBodyWriter)buildTimeWriters.get(0);
                            handlers.add(new FixedProducesHandler(mediaType, new FixedEntityWriter(writer, this.serialisers)));
                            if (writer instanceof ServerMessageBodyWriter) {
                                score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTimeDirect(writer));
                            } else {
                                score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTime(writer));
                            }
                        } else {
                            handlers.add(new FixedProducesHandler(mediaType, new FixedEntityWriterArray(buildTimeWriters.toArray(EMPTY_MESSAGE_BODY_WRITERS), this.serialisers)));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTimeMultiple(buildTimeWriters));
                        }
                    } else {
                        score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterNotRequired);
                    }
                } else {
                    handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                    score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                }
            } else {
                score.add((Object)ScoreSystem.Category.Writer, (Object)(RuntimeResourceDeployment.isNotVoid(rawEffectiveReturnType) ? ScoreSystem.Diagnostic.WriterRunTime : ScoreSystem.Diagnostic.WriterNotRequired));
            }
        } else {
            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
        }
        if (method.isSse()) {
            handlers.add(SseResponseWriterHandler.INSTANCE);
            responseFilterHandlers = Collections.emptyList();
        } else {
            this.addResponseHandler(method, handlers);
            this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_RESPONSE_CREATED);
            responseFilterHandlers = new ArrayList<ServerRestHandler>(interceptorDeployment.setupResponseFilterHandler());
            handlers.addAll(responseFilterHandlers);
            handlers.add(this.responseWriterHandler);
        }
        if (!clazz.resourceExceptionMapper().isEmpty() && instanceHandler != null) {
            abortHandlingChain.add(instanceHandler);
        }
        abortHandlingChain.add(ExceptionHandler.INSTANCE);
        abortHandlingChain.add(ResponseHandler.NO_CUSTOMIZER_INSTANCE);
        abortHandlingChain.addAll(responseFilterHandlers);
        abortHandlingChain.add(this.responseWriterHandler);
        handlers.set(0, new AbortChainHandler(abortHandlingChain.toArray(EMPTY_REST_HANDLER_ARRAY)));
        return new RuntimeResource(method.getHttpMethod(), methodPathTemplate, classPathTemplate, method.getProduces() == null ? null : serverMediaType, consumesMediaTypes, invoker, (BeanFactory<Object>)clazz.getFactory(), handlers.toArray(EMPTY_REST_HANDLER_ARRAY), method.getName(), parameterDeclaredTypes, effectiveReturnType, method.isBlocking(), method.isRunOnVirtualThread(), resourceClass, lazyMethod, pathParameterIndexes, (Map<ScoreSystem.Category, List<ScoreSystem.Diagnostic>>)(info.isDevelopmentMode() ? score : null), streamElementType, clazz.resourceExceptionMapper());
    }

    private static void smartInitParameterConverter(int i, ParameterConverter quarkusConverter, ParamConverterProviders paramConverterProviders, Class<?>[] parameterTypes, Type[] genericParameterTypes, Annotation[][] parameterAnnotations) {
        Type[] genericArguments;
        if (quarkusConverter.isForSingleObjectContainer() && genericParameterTypes[i] instanceof ParameterizedType && (genericArguments = ((ParameterizedType)genericParameterTypes[i]).getActualTypeArguments()).length == 1) {
            String genericTypeClassName = null;
            Type genericType = genericArguments[0];
            if (genericType instanceof Class) {
                genericTypeClassName = ((Class)genericType).getName();
            } else if (genericType instanceof WildcardType) {
                Type genericTypeUpperBoundType;
                WildcardType genericTypeWildcardType = (WildcardType)genericType;
                Type[] upperBounds = genericTypeWildcardType.getUpperBounds();
                Type[] lowerBounds = genericTypeWildcardType.getLowerBounds();
                if (lowerBounds.length == 0 && upperBounds.length == 1 && (genericTypeUpperBoundType = upperBounds[0]) instanceof Class) {
                    genericTypeClassName = ((Class)genericTypeUpperBoundType).getName();
                }
            }
            if (genericTypeClassName == null) {
                throw new IllegalArgumentException("Unable to support parameter converter with type: '" + genericType.getTypeName() + "'");
            }
            quarkusConverter.init(paramConverterProviders, DeploymentUtils.loadClass((String)genericTypeClassName), genericArguments[0], parameterAnnotations[i]);
            return;
        }
        quarkusConverter.init(paramConverterProviders, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i]);
    }

    private static boolean isNotVoid(Class<?> rawEffectiveReturnType) {
        return rawEffectiveReturnType != Void.class && rawEffectiveReturnType != Void.TYPE;
    }

    private void addResponseHandler(ServerResourceMethod method, List<ServerRestHandler> handlers) {
        if (method.getHandlerChainCustomizers().isEmpty()) {
            handlers.add(ResponseHandler.NO_CUSTOMIZER_INSTANCE);
        } else {
            ArrayList<ResponseHandler.ResponseBuilderCustomizer> customizers = new ArrayList<ResponseHandler.ResponseBuilderCustomizer>(method.getHandlerChainCustomizers().size());
            for (int i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
                ResponseHandler.ResponseBuilderCustomizer customizer = method.getHandlerChainCustomizers().get(i).successfulInvocationResponseBuilderCustomizer(method);
                if (customizer == null) continue;
                customizers.add(customizer);
            }
            handlers.add(new ResponseHandler(customizers));
        }
    }

    private void addStreamingResponseCustomizers(ServerResourceMethod method, List<ServerRestHandler> handlers) {
        int i;
        ArrayList<PublisherResponseHandler.StreamingResponseCustomizer> customizers = new ArrayList<PublisherResponseHandler.StreamingResponseCustomizer>(method.getHandlerChainCustomizers().size());
        for (i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
            PublisherResponseHandler.StreamingResponseCustomizer streamingResponseCustomizer = method.getHandlerChainCustomizers().get(i).streamingResponseCustomizer(method);
            if (streamingResponseCustomizer == null) continue;
            customizers.add(streamingResponseCustomizer);
        }
        if (!customizers.isEmpty()) {
            for (i = 0; i < handlers.size(); ++i) {
                ServerRestHandler serverRestHandler = handlers.get(i);
                if (!(serverRestHandler instanceof PublisherResponseHandler)) continue;
                ((PublisherResponseHandler)serverRestHandler).setStreamingResponseCustomizers(customizers);
                return;
            }
        }
    }

    private boolean isSingleEffectiveWriter(List<MessageBodyWriter<?>> buildTimeWriters) {
        if (buildTimeWriters.size() == 1) {
            return true;
        }
        return buildTimeWriters.get(0) instanceof AllWriteableMarker;
    }

    private boolean addHandlers(List<ServerRestHandler> handlers, ResourceClass clazz, ServerResourceMethod method, DeploymentInfo info, HandlerChainCustomizer.Phase phase) {
        int i;
        int originalHandlersSize = handlers.size();
        for (i = 0; i < info.getGlobalHandlerCustomizers().size(); ++i) {
            handlers.addAll(info.getGlobalHandlerCustomizers().get(i).handlers(phase, clazz, method));
        }
        for (i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
            handlers.addAll(method.getHandlerChainCustomizers().get(i).handlers(phase, clazz, method));
        }
        return originalHandlersSize != handlers.size();
    }

    private ServerRestHandler alternateInvoker(ServerResourceMethod method, EndpointInvoker invoker) {
        for (int i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
            ServerRestHandler ret = method.getHandlerChainCustomizers().get(i).alternateInvocationHandler(invoker);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public ParameterExtractor parameterExtractor(Map<String, Integer> pathParameterIndexes, boolean locatableResource, ServerMethodParameter param) {
        switch (param.parameterType) {
            case HEADER: {
                return new HeaderParamExtractor(param.name, param.isSingle());
            }
            case COOKIE: {
                return new CookieParamExtractor(param.name, param.type);
            }
            case FORM: {
                MultipartFormParamExtractor.Type multiPartType = null;
                Class typeClass = null;
                Type genericType = null;
                if (param.type.equals(FileUpload.class.getName())) {
                    multiPartType = MultipartFormParamExtractor.Type.FileUpload;
                } else if (param.type.equals(File.class.getName())) {
                    multiPartType = MultipartFormParamExtractor.Type.File;
                } else if (param.type.equals(Path.class.getName())) {
                    multiPartType = MultipartFormParamExtractor.Type.Path;
                } else if (param.type.equals(String.class.getName())) {
                    multiPartType = MultipartFormParamExtractor.Type.String;
                } else if (param.type.equals(InputStream.class.getName())) {
                    multiPartType = MultipartFormParamExtractor.Type.InputStream;
                } else if (param.type.equals(byte[].class.getName())) {
                    multiPartType = MultipartFormParamExtractor.Type.ByteArray;
                } else if (param.mimeType != null && !param.mimeType.equals("text/plain")) {
                    multiPartType = MultipartFormParamExtractor.Type.PartType;
                    typeClass = DeploymentUtils.loadClass((String)param.type);
                    genericType = TypeSignatureParser.parse((String)param.signature);
                    genericType = Types.getMultipartElementType((Type)genericType);
                }
                if (multiPartType != null) {
                    return new MultipartFormParamExtractor(param.name, param.isSingle(), multiPartType, typeClass, genericType, param.mimeType, param.encoded);
                }
                return new FormParamExtractor(param.name, param.isSingle(), param.encoded);
            }
            case PATH: {
                Integer index = pathParameterIndexes.get(param.name);
                ParameterExtractor extractor = index == null ? (locatableResource ? new LocatableResourcePathParamExtractor(param.name) : new NullParamExtractor()) : new PathParamExtractor(index, param.encoded, param.isSingle());
                return extractor;
            }
            case CONTEXT: {
                return new ContextParamExtractor(param.type);
            }
            case ASYNC_RESPONSE: {
                return new AsyncResponseExtractor();
            }
            case QUERY: {
                QueryParamExtractor extractor = new QueryParamExtractor(param.name, param.isSingle(), param.encoded, param.separator);
                return extractor;
            }
            case BODY: {
                return new BodyParamExtractor();
            }
            case MATRIX: {
                MatrixParamExtractor extractor = new MatrixParamExtractor(param.name, param.isSingle(), param.encoded);
                return extractor;
            }
            case BEAN: 
            case MULTI_PART_FORM: {
                return new InjectParamExtractor(this.info.getFactoryCreator().apply(DeploymentUtils.loadClass((String)param.type)));
            }
            case CUSTOM: {
                return param.customParameterExtractor;
            }
        }
        throw new RuntimeException("Unknown param type: " + param.parameterType);
    }

    public Map<String, Integer> buildParamIndexMap(URITemplate classPathTemplate, URITemplate methodPathTemplate) {
        HashMap<String, Integer> pathParameterIndexes = new HashMap<String, Integer>();
        int pathCount = 0;
        if (classPathTemplate != null) {
            for (URITemplate.TemplateComponent i : classPathTemplate.components) {
                if (i.name != null) {
                    pathParameterIndexes.put(i.name, pathCount++);
                    continue;
                }
                if (i.names == null) continue;
                for (String nm : i.names) {
                    pathParameterIndexes.put(nm, pathCount++);
                }
            }
        }
        for (URITemplate.TemplateComponent i : methodPathTemplate.components) {
            if (i.name != null) {
                pathParameterIndexes.put(i.name, pathCount++);
                continue;
            }
            if (i.names == null) continue;
            for (String nm : i.names) {
                pathParameterIndexes.put(nm, pathCount++);
            }
        }
        return pathParameterIndexes;
    }
}

