/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.common.headers.MediaTypeHeaderDelegate;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.ResponseBuilderImpl;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ClassRoutingHandler
implements ServerRestHandler {
    private static final String INVALID_ACCEPT_HEADER_MESSAGE = "The accept header value did not match the value in @Produces";
    private final Map<String, RequestMapper<RuntimeResource>> mappers;
    private final int parameterOffset;

    public ClassRoutingHandler(Map<String, RequestMapper<RuntimeResource>> mappers, int parameterOffset) {
        this.mappers = mappers;
        this.parameterOffset = parameterOffset;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        String pathParamValue;
        String accepts;
        String contentType;
        String remaining;
        RequestMapper.RequestMatch<RuntimeResource> target;
        RequestMapper<RuntimeResource> mapper = this.mappers.get(requestContext.getMethod());
        if (mapper == null) {
            String requestMethod = requestContext.getMethod();
            if (requestMethod.equals("HEAD")) {
                mapper = this.mappers.get("GET");
            } else if (requestMethod.equals("OPTIONS")) {
                HashSet<CharSequence> allowedMethods = new HashSet<CharSequence>();
                for (String method : this.mappers.keySet()) {
                    if (method == null) continue;
                    allowedMethods.add(method);
                }
                allowedMethods.add("OPTIONS");
                allowedMethods.add("HEAD");
                requestContext.serverResponse().setResponseHeader((CharSequence)"Allow", allowedMethods).end();
                return;
            }
            if (mapper == null) {
                mapper = this.mappers.get(null);
            }
            if (mapper == null) {
                String remaining2 = this.getRemaining(requestContext);
                for (RequestMapper<RuntimeResource> existingMapper : this.mappers.values()) {
                    if (existingMapper.map(remaining2) == null) continue;
                    throw new NotAllowedException(new ResponseBuilderImpl().status(Response.Status.METHOD_NOT_ALLOWED).build());
                }
                this.throwNotFound(requestContext);
                return;
            }
        }
        if ((target = mapper.map(remaining = this.getRemaining(requestContext))) == null) {
            if (requestContext.getMethod().equals("HEAD") && (mapper = this.mappers.get("GET")) != null) {
                target = mapper.map(remaining);
            }
            if (target == null) {
                for (Map.Entry<String, RequestMapper<RuntimeResource>> entry : this.mappers.entrySet()) {
                    if (entry.getKey() == null || entry.getKey().equals(requestContext.getMethod()) || entry.getValue().map(remaining) == null) continue;
                    throw new NotAllowedException(new ResponseBuilderImpl().status(Response.Status.METHOD_NOT_ALLOWED).build());
                }
                this.throwNotFound(requestContext);
                return;
            }
        }
        ServerHttpRequest serverRequest = requestContext.serverRequest();
        if (!((RuntimeResource)target.value).getConsumes().isEmpty() && (contentType = serverRequest.getRequestHeader("Content-Type")) != null && MediaTypeHelper.getFirstMatch(((RuntimeResource)target.value).getConsumes(), Collections.singletonList(MediaType.valueOf((String)contentType))) == null) {
            throw new NotSupportedException("The content-type header value did not match the value in @Consumes");
        }
        if (((RuntimeResource)target.value).getProduces() != null && (accepts = serverRequest.getRequestHeader("Accept")) != null && !accepts.equals("*/*")) {
            int commaIndex = accepts.indexOf(44);
            boolean multipleAcceptsValues = commaIndex >= 0;
            MediaType[] producesMediaTypes = ((RuntimeResource)target.value).getProduces().getSortedOriginalMediaTypes();
            if (!multipleAcceptsValues && producesMediaTypes.length == 1) {
                MediaType providedMediaType = producesMediaTypes[0];
                MediaType acceptsMediaType = MediaType.valueOf((String)accepts.trim());
                if (!providedMediaType.isCompatible(acceptsMediaType)) {
                    throw new NotAcceptableException(INVALID_ACCEPT_HEADER_MESSAGE);
                }
            } else if (multipleAcceptsValues && producesMediaTypes.length == 1) {
                boolean compatible = false;
                int begin = 0;
                while (true) {
                    String acceptPart;
                    if (producesMediaTypes[0].isCompatible(this.toMediaType((acceptPart = commaIndex == -1 ? accepts.substring(begin) : accepts.substring(begin, commaIndex)).trim()))) {
                        compatible = true;
                        break;
                    }
                    if (commaIndex == -1 || (begin = commaIndex + 1) >= accepts.length() - 1) break;
                    commaIndex = accepts.indexOf(44, begin);
                }
                if (!compatible) {
                    throw new NotAcceptableException(INVALID_ACCEPT_HEADER_MESSAGE);
                }
            } else {
                List<MediaType> acceptsMediaTypes;
                if (accepts.contains(",")) {
                    String[] parts = accepts.split(",");
                    acceptsMediaTypes = new ArrayList<MediaType>(parts.length);
                    for (int i = 0; i < parts.length; ++i) {
                        String part = parts[i];
                        acceptsMediaTypes.add(this.toMediaType(part.trim()));
                    }
                } else {
                    acceptsMediaTypes = Collections.singletonList(this.toMediaType(accepts));
                }
                if (MediaTypeHelper.getFirstMatch(Arrays.asList(producesMediaTypes), acceptsMediaTypes) == null) {
                    throw new NotAcceptableException(INVALID_ACCEPT_HEADER_MESSAGE);
                }
            }
        }
        requestContext.restart((RuntimeResource)target.value);
        requestContext.setRemaining(target.remaining);
        for (int i = 0; i < target.pathParamValues.length && (pathParamValue = target.pathParamValues[i]) != null; ++i) {
            requestContext.setPathParamValue(i + this.parameterOffset, pathParamValue);
        }
    }

    private MediaType toMediaType(String mediaTypeStr) {
        return MediaTypeHeaderDelegate.parse((String)mediaTypeStr);
    }

    private void throwNotFound(ResteasyReactiveRequestContext requestContext) {
        requestContext.requireCDIRequestScope();
        throw new NotFoundException("Unable to find matching target resource method");
    }

    private String getRemaining(ResteasyReactiveRequestContext requestContext) {
        return requestContext.getRemaining().isEmpty() ? "/" : requestContext.getRemaining();
    }

    public Map<String, RequestMapper<RuntimeResource>> getMappers() {
        return this.mappers;
    }
}

