/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionTarget;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResourceLocatorHandler
implements ServerRestHandler {
    private final Map<Class<?>, Map<String, RequestMapper<RuntimeResource>>> resourceLocatorHandlers = new ConcurrentHashMap();
    private final Function<Class<?>, BeanFactory.BeanInstance<?>> instantiator;
    private final Function<Object, Object> clientProxyUnwrapper;

    public ResourceLocatorHandler(Function<Class<?>, BeanFactory.BeanInstance<?>> instantiator, Function<Object, Object> clientProxyUnwrapper) {
        this.instantiator = instantiator;
        this.clientProxyUnwrapper = clientProxyUnwrapper;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        String pathParamValue;
        Map<String, RequestMapper<RuntimeResource>> target;
        Class<?> locatorClass;
        Object locator = requestContext.getResult();
        if (locator == null) {
            return;
        }
        if (locator instanceof Class) {
            locatorClass = (Class<?>)locator;
            final BeanFactory.BeanInstance<?> instance = this.instantiator.apply(locatorClass);
            requestContext.registerCompletionCallback(new CompletionCallback(){

                public void onComplete(Throwable throwable) {
                    instance.close();
                }
            });
            locator = instance.getInstance();
            if (locator == null) {
                locator = locatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        } else {
            locatorClass = locator.getClass();
        }
        Object unwrapped = null;
        if (this.clientProxyUnwrapper != null) {
            unwrapped = this.clientProxyUnwrapper.apply(locator);
        }
        if (unwrapped instanceof ResteasyReactiveInjectionTarget) {
            ResteasyReactiveInjectionTarget t = (ResteasyReactiveInjectionTarget)unwrapped;
            if (unwrapped != locator) {
                t.__quarkus_rest_inject(requestContext);
            }
        }
        if ((target = this.findTarget(locatorClass)) == null) {
            throw new RuntimeException("Resource locator method returned object that was not a resource: " + String.valueOf(locator));
        }
        RequestMapper<RuntimeResource> mapper = target.get(requestContext.getMethod());
        boolean hadNullMethodMapper = false;
        if (mapper == null) {
            mapper = target.get(null);
            hadNullMethodMapper = true;
            if (mapper == null) {
                String requestMethod = requestContext.getMethod();
                if (requestMethod.equals("HEAD")) {
                    mapper = target.get("GET");
                } else if (requestMethod.equals("OPTIONS")) {
                    HashSet<String> allowedMethods = new HashSet<String>();
                    for (String method : target.keySet()) {
                        if (method == null) continue;
                        allowedMethods.add(method);
                    }
                    allowedMethods.add("OPTIONS");
                    allowedMethods.add("HEAD");
                    requestContext.abortWith(Response.ok().allow(allowedMethods).build());
                    return;
                }
            }
        }
        if (mapper == null) {
            throw new WebApplicationException(Response.status((int)Response.Status.METHOD_NOT_ALLOWED.getStatusCode()).build());
        }
        RequestMapper.RequestMatch<RuntimeResource> res = mapper.map(requestContext.getRemaining().isEmpty() ? "/" : requestContext.getRemaining());
        if (res == null) {
            if (hadNullMethodMapper) {
                throw new WebApplicationException(Response.status((int)Response.Status.METHOD_NOT_ALLOWED.getStatusCode()).build());
            }
            throw new WebApplicationException(Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).build());
        }
        requestContext.saveUriMatchState();
        requestContext.setRemaining(res.remaining);
        requestContext.setEndpointInstance(locator);
        requestContext.setResult(null);
        requestContext.restart((RuntimeResource)res.value, true);
        requestContext.setMaxPathParams(res.pathParamValues.length);
        for (int i = 0; i < res.pathParamValues.length && (pathParamValue = res.pathParamValues[i]) != null; ++i) {
            requestContext.setPathParamValue(i, pathParamValue);
        }
    }

    private Map<String, RequestMapper<RuntimeResource>> findTarget(Class<?> locatorClass) {
        if (locatorClass == Object.class || locatorClass == null) {
            return null;
        }
        Map<String, RequestMapper<RuntimeResource>> res = this.resourceLocatorHandlers.get(locatorClass);
        if (res != null) {
            return res;
        }
        ArrayList<Map<String, RequestMapper<RuntimeResource>>> results = new ArrayList<Map<String, RequestMapper<RuntimeResource>>>();
        HashSet seen = new HashSet();
        this.findTargetRecursive(locatorClass, results, seen);
        HashMap newMapper = new HashMap();
        for (Map map : results) {
            for (Map.Entry entry : map.entrySet()) {
                ArrayList list = (ArrayList)newMapper.get(entry.getKey());
                if (list == null) {
                    list = new ArrayList();
                    newMapper.put((String)entry.getKey(), list);
                }
                list.addAll(((RequestMapper)entry.getValue()).getTemplates());
            }
        }
        HashMap<String, RequestMapper<RuntimeResource>> finalResult = new HashMap<String, RequestMapper<RuntimeResource>>();
        for (Map.Entry i : newMapper.entrySet()) {
            finalResult.put((String)i.getKey(), new RequestMapper((ArrayList)i.getValue()));
        }
        this.resourceLocatorHandlers.put(locatorClass, finalResult);
        return finalResult;
    }

    private void findTargetRecursive(Class<?> locatorClass, List<Map<String, RequestMapper<RuntimeResource>>> found, Set<Class<?>> seen) {
        if (locatorClass == Object.class || locatorClass == null) {
            return;
        }
        boolean superRequired = true;
        Map<String, RequestMapper<RuntimeResource>> res = this.resourceLocatorHandlers.get(locatorClass);
        if (res != null) {
            found.add(res);
            superRequired = false;
        }
        for (Class<?> iface : locatorClass.getInterfaces()) {
            if (seen.contains(iface)) continue;
            seen.add(iface);
            res = this.resourceLocatorHandlers.get(iface);
            if (res != null) {
                found.add(res);
            }
            for (Class<?> i : iface.getInterfaces()) {
                this.findTargetRecursive(i, found, seen);
            }
        }
        if (superRequired) {
            this.findTargetRecursive(locatorClass.getSuperclass(), found, seen);
        }
    }

    public void addResource(Class<?> resourceClass, Map<String, RequestMapper<RuntimeResource>> requestMapper) {
        Class<?> c = resourceClass;
        this.resourceLocatorHandlers.put(c, requestMapper);
    }
}

