/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.identity;

import io.quarkus.security.credential.Credential;
import io.smallrye.mutiny.Uni;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Set;

public interface SecurityIdentity {
    public static final String USER_ATTRIBUTE = "quarkus.user";

    public Principal getPrincipal();

    public boolean isAnonymous();

    @Deprecated
    public Set<String> getRoles();

    public boolean hasRole(String var1);

    public <T extends Credential> T getCredential(Class<T> var1);

    public Set<Credential> getCredentials();

    public <T> T getAttribute(String var1);

    public Map<String, Object> getAttributes();

    public Uni<Boolean> checkPermission(Permission var1);

    default public boolean checkPermissionBlocking(Permission permission) {
        return (Boolean)this.checkPermission(permission).await().indefinitely();
    }
}

