/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.utils;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.utils.AppendBuffer;
import io.quarkus.vertx.utils.NoBoundChecksBuffer;
import io.quarkus.vertx.utils.VertxJavaIoContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Optional;
import org.jboss.logging.Logger;

public class VertxOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger((String)"org.jboss.resteasy.reactive.server.vertx.ResteasyReactiveOutputStream");
    private final VertxJavaIoContext context;
    private final HttpServerRequest request;
    private final AppendBuffer appendBuffer;
    private boolean committed;
    private boolean closed;
    private boolean waitingForDrain;
    private boolean first = true;
    private Throwable throwable;
    private ByteArrayOutputStream overflow;

    public VertxOutputStream(VertxJavaIoContext context) {
        this.context = context;
        this.request = context.getRoutingContext().request();
        this.appendBuffer = AppendBuffer.withMinChunks(context.getMinChunkSize(), context.getOutputBufferCapacity());
        this.request.response().exceptionHandler((Handler)new Handler<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Throwable event) {
                VertxOutputStream.this.throwable = event;
                log.debugf(event, "IO Exception ", new Object[0]);
                VertxOutputStream.this.request.connection().close();
                HttpConnection httpConnection = VertxOutputStream.this.request.connection();
                synchronized (httpConnection) {
                    if (VertxOutputStream.this.waitingForDrain) {
                        VertxOutputStream.this.request.connection().notifyAll();
                    }
                }
            }
        });
        DrainHandler handler = new DrainHandler(this);
        this.request.response().drainHandler((Handler)handler);
        this.request.response().closeHandler((Handler)handler);
        context.getRoutingContext().addEndHandler((Handler)new Handler<AsyncResult<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(AsyncResult<Void> event) {
                HttpConnection httpConnection = VertxOutputStream.this.request.connection();
                synchronized (httpConnection) {
                    if (VertxOutputStream.this.waitingForDrain) {
                        VertxOutputStream.this.request.connection().notifyAll();
                    }
                }
            }
        });
    }

    private Buffer createBuffer(ByteBuf data) {
        return new NoBoundChecksBuffer(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ByteBuf data, boolean last) throws IOException {
        if (last && data == null) {
            this.request.response().end((Handler)null);
            return;
        }
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            try {
                boolean bufferRequired;
                boolean bl = bufferRequired = this.awaitWriteable() || this.overflow != null && this.overflow.size() > 0;
                if (bufferRequired) {
                    if (this.overflow == null) {
                        this.overflow = new ByteArrayOutputStream();
                    }
                    if (data.hasArray()) {
                        this.overflow.write(data.array(), data.arrayOffset() + data.readerIndex(), data.readableBytes());
                    } else {
                        data.getBytes(data.readerIndex(), (OutputStream)this.overflow, data.readableBytes());
                    }
                    if (last) {
                        this.closed = true;
                    }
                    data.release();
                } else if (last) {
                    this.request.response().end(this.createBuffer(data), null);
                } else {
                    this.request.response().write((Object)this.createBuffer(data), null);
                }
            }
            catch (Exception e) {
                if (data != null && data.refCnt() > 0) {
                    data.release();
                }
                throw new IOException("Failed to write", e);
            }
        }
    }

    private boolean awaitWriteable() throws IOException {
        if (Vertx.currentContext() == ((HttpServerRequestInternal)this.request).context()) {
            return false;
        }
        if (this.first) {
            this.first = false;
            return false;
        }
        assert (Thread.holdsLock(this.request.connection()));
        while (this.request.response().writeQueueFull()) {
            if (this.throwable != null) {
                throw new IOException(this.throwable);
            }
            if (this.request.response().closed()) {
                throw new IOException("Connection has been closed");
            }
            try {
                this.waitingForDrain = true;
                this.request.connection().wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForDrain = false;
            }
        }
        return false;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int rem = len;
        int idx = off;
        try {
            while (rem > 0) {
                int written = this.appendBuffer.append(b, idx, rem);
                if (written < rem) {
                    this.writeBlocking(this.appendBuffer.clear(), false);
                }
                rem -= written;
                idx += written;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void writeBlocking(ByteBuf buffer, boolean finished) throws IOException {
        this.prepareWrite(buffer, finished);
        this.write(buffer, finished);
    }

    private void prepareWrite(ByteBuf buffer, boolean finished) throws IOException {
        if (!this.committed) {
            this.committed = true;
            HttpServerResponse response = this.request.response();
            if (finished) {
                if (!response.headWritten()) {
                    if (buffer == null) {
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)"0");
                    } else {
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(buffer.readableBytes()));
                    }
                }
            } else {
                Optional<String> contentLength = this.context.getContentLength();
                if (contentLength.isEmpty()) {
                    response.setChunked(true);
                } else {
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)contentLength.get());
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        try {
            ByteBuf toFlush = this.appendBuffer.clear();
            if (toFlush != null) {
                this.writeBlocking(toFlush, false);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.writeBlocking(this.appendBuffer.clear(), true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.closed = true;
        }
    }

    private static class DrainHandler
    implements Handler<Void> {
        private final VertxOutputStream out;

        public DrainHandler(VertxOutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Void event) {
            HttpConnection httpConnection = this.out.request.connection();
            synchronized (httpConnection) {
                if (this.out.waitingForDrain) {
                    this.out.request.connection().notifyAll();
                }
                if (this.out.overflow != null && this.out.overflow.size() > 0) {
                    if (this.out.closed) {
                        this.out.request.response().end(Buffer.buffer((byte[])this.out.overflow.toByteArray()), null);
                    } else {
                        this.out.request.response().write((Object)Buffer.buffer((byte[])this.out.overflow.toByteArray()), null);
                    }
                    this.out.overflow.reset();
                }
            }
        }
    }
}

