/*
 * Decompiled with CFR 0.152.
 */
package io.quickchart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.json.JSONTokener;

public class QuickChart {
    private Integer width = 500;
    private Integer height = 300;
    private Double devicePixelRatio = 1.0;
    private String backgroundColor = "transparent";
    private String key;
    private String version;
    private String config;
    private String scheme;
    private String host;
    private Integer port;

    public QuickChart() {
        this("https", "quickchart.io", 443);
    }

    public QuickChart(String scheme, String host, Integer port) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public void setDevicePixelRatio(double devicePixelRatio) {
        this.devicePixelRatio = devicePixelRatio;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getUrl() {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.scheme);
        builder.setHost(this.host);
        if (this.port != 80 && this.port != 443) {
            builder.setPort(this.port.intValue());
        }
        builder.setPath("/chart");
        builder.addParameter("w", this.width.toString());
        builder.addParameter("h", this.height.toString());
        builder.addParameter("devicePixelRatio", this.devicePixelRatio.toString());
        if (!this.backgroundColor.equals("transparent")) {
            builder.addParameter("bkg", this.backgroundColor);
        }
        builder.addParameter("c", this.config);
        if (this.key != null && !this.key.isEmpty()) {
            builder.addParameter("key", this.key);
        }
        if (this.version != null && !this.version.isEmpty()) {
            builder.addParameter("v", this.version);
        }
        return builder.toString();
    }

    private String getPostJson() {
        JSONObject jsonBuilder = new JSONObject();
        jsonBuilder.put("width", (Object)this.width.toString());
        jsonBuilder.put("height", (Object)this.height.toString());
        jsonBuilder.put("devicePixelRatio", (Object)this.devicePixelRatio.toString());
        if (!this.backgroundColor.equals("transparent")) {
            jsonBuilder.put("backgroundColor", (Object)this.backgroundColor);
        }
        jsonBuilder.put("chart", (Object)this.config);
        if (this.key != null && !this.key.isEmpty()) {
            jsonBuilder.put("key", (Object)this.key);
        }
        if (this.version != null && !this.version.isEmpty()) {
            jsonBuilder.put("version", (Object)this.version);
        }
        return jsonBuilder.toString();
    }

    private HttpEntity executePost(String path) throws IOException {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(this.scheme);
        uriBuilder.setHost(this.host);
        if (this.port != 80 && this.port != 443) {
            uriBuilder.setPort(this.port.intValue());
        }
        uriBuilder.setPath(path);
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(uriBuilder.toString());
        StringEntity entity = new StringEntity(this.getPostJson());
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("Received invalid status code from API endpoint");
        }
        HttpEntity ret = response.getEntity();
        return ret;
    }

    public String getShortUrl() {
        try {
            HttpEntity entity = this.executePost("/chart/create");
            String rawResponse = EntityUtils.toString((HttpEntity)entity);
            JSONTokener tokener = new JSONTokener(rawResponse);
            JSONObject jsonResponse = new JSONObject(tokener);
            return jsonResponse.getString("url");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public byte[] toByteArray() {
        try {
            HttpEntity entity = this.executePost("/chart");
            return EntityUtils.toByteArray((HttpEntity)entity);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String toDataUrl() {
        try {
            HttpEntity entity = this.executePost("/chart");
            return "data:image/png;base64," + Base64.getEncoder().encode(EntityUtils.toByteArray((HttpEntity)entity));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void toFile(String filePath) throws IOException {
        HttpEntity entity = this.executePost("/chart");
        BufferedHttpEntity entityBuffer = new BufferedHttpEntity(entity);
        FileOutputStream os = new FileOutputStream(new File(filePath));
        entityBuffer.writeTo((OutputStream)os);
    }
}

