/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.client;

import io.r2dbc.h2.util.Assert;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.h2.value.Value;

public final class Binding {
    static final Binding EMPTY = new Binding();
    private final SortedMap<Integer, Value> parameters = new TreeMap<Integer, Value>();

    public Binding add(Integer index, Value value) {
        Assert.requireNonNull(index, "index must not be null");
        Assert.requireNonNull(value, "value must not be null");
        this.parameters.put(index, value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Binding)) {
            return false;
        }
        Binding that = (Binding)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public String toString() {
        return "Binding{parameters=" + this.parameters + '}';
    }

    SortedMap<Integer, Value> getParameters() {
        return this.parameters;
    }
}

