/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;

final class BooleanCodec
extends AbstractCodec<Boolean> {
    BooleanCodec() {
        super(Boolean.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 1;
    }

    @Override
    Boolean doDecode(Value value, Class<? extends Boolean> type) {
        return value.getBoolean();
    }

    @Override
    Value doEncode(Boolean value) {
        return ValueBoolean.get((boolean)Assert.requireNonNull(value, "value must not be null"));
    }
}

