/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.codecs.BigDecimalCodec;
import io.r2dbc.h2.codecs.BlobCodec;
import io.r2dbc.h2.codecs.BlobToByteBufferCodec;
import io.r2dbc.h2.codecs.BooleanCodec;
import io.r2dbc.h2.codecs.ByteCodec;
import io.r2dbc.h2.codecs.BytesCodec;
import io.r2dbc.h2.codecs.ClobCodec;
import io.r2dbc.h2.codecs.ClobToStringCodec;
import io.r2dbc.h2.codecs.Codec;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.h2.codecs.DoubleCodec;
import io.r2dbc.h2.codecs.FloatCodec;
import io.r2dbc.h2.codecs.GeometryCodec;
import io.r2dbc.h2.codecs.InstantCodec;
import io.r2dbc.h2.codecs.IntegerCodec;
import io.r2dbc.h2.codecs.LocalDateCodec;
import io.r2dbc.h2.codecs.LocalDateTimeCodec;
import io.r2dbc.h2.codecs.LocalTimeCodec;
import io.r2dbc.h2.codecs.LongCodec;
import io.r2dbc.h2.codecs.OffsetDateTimeCodec;
import io.r2dbc.h2.codecs.ShortCodec;
import io.r2dbc.h2.codecs.StringCodec;
import io.r2dbc.h2.codecs.UuidCodec;
import io.r2dbc.h2.codecs.ZonedDateTimeCodec;
import io.r2dbc.h2.util.Assert;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.h2.value.Value;
import reactor.util.annotation.Nullable;

public final class DefaultCodecs
implements Codecs {
    private final List<Codec<?>> codecs;

    public DefaultCodecs(Client client) {
        this.codecs = DefaultCodecs.createCodecs(client, client.getClass().getClassLoader());
    }

    @Override
    @Nullable
    public <T> T decode(Value value, int dataType, Class<? extends T> type) {
        Assert.requireNonNull(type, "type must not be null");
        if (value == null) {
            return null;
        }
        for (Codec<T> codec : this.codecs) {
            if (!codec.canDecode(dataType, type)) continue;
            return (T)codec.decode(value, type);
        }
        throw new IllegalArgumentException(String.format("Cannot decode value of type %s", type.getName()));
    }

    @Override
    public Value encode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncode(value)) continue;
            return codec.encode(value);
        }
        throw new IllegalArgumentException(String.format("Cannot encode parameter of type %s", value.getClass().getName()));
    }

    @Override
    public Value encodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncodeNull(type)) continue;
            return codec.encodeNull();
        }
        throw new IllegalArgumentException(String.format("Cannot encode null parameter of type %s", type.getName()));
    }

    @Override
    public Class<?> preferredType(int dataType) {
        for (Codec<Object> codec : this.codecs) {
            if (!codec.canDecode(dataType, Object.class)) continue;
            return codec.type();
        }
        return null;
    }

    static List<Codec<?>> createCodecs(Client client, ClassLoader classLoader) {
        return Stream.concat(Stream.of(new BigDecimalCodec(), new BlobToByteBufferCodec(client), new BlobCodec(client), new BooleanCodec(), new ByteCodec(), new BytesCodec(), new ClobCodec(client), new DoubleCodec(), new FloatCodec(), new IntegerCodec(), new LocalDateCodec(), new LocalDateTimeCodec(client), new LocalTimeCodec(), new LongCodec(), new OffsetDateTimeCodec(client), new ShortCodec(), new StringCodec(), new UuidCodec(), new ZonedDateTimeCodec(client), new InstantCodec(client), new ClobToStringCodec(client)), DefaultCodecs.addOptionalCodecs(classLoader)).collect(Collectors.toList());
    }

    static Stream<Codec<?>> addOptionalCodecs(ClassLoader classLoader) {
        Stream.Builder<GeometryCodec> optionalCodecs = Stream.builder();
        if (DefaultCodecs.isPresent(classLoader, "org.locationtech.jts.geom.Geometry")) {
            optionalCodecs.accept(new GeometryCodec());
        }
        return optionalCodecs.build();
    }

    static boolean isPresent(ClassLoader classLoader, String fullyQualifiedClassName) {
        try {
            classLoader.loadClass(fullyQualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

