/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import java.time.LocalDate;
import org.h2.util.JSR310Utils;
import org.h2.value.Value;

final class LocalDateCodec
extends AbstractCodec<LocalDate> {
    LocalDateCodec() {
        super(LocalDate.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 10;
    }

    @Override
    LocalDate doDecode(Value value, Class<? extends LocalDate> type) {
        return (LocalDate)JSR310Utils.valueToLocalDate((Value)value);
    }

    @Override
    Value doEncode(LocalDate value) {
        return JSR310Utils.localDateToValue((Object)Assert.requireNonNull(value, "value must not be null"));
    }
}

