/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.CloseableConnectionFactory;
import io.r2dbc.h2.H2Connection;
import io.r2dbc.h2.H2ConnectionConfiguration;
import io.r2dbc.h2.H2ConnectionFactoryMetadata;
import io.r2dbc.h2.H2ConnectionOption;
import io.r2dbc.h2.H2DatabaseExceptionFactory;
import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.client.SessionClient;
import io.r2dbc.h2.codecs.DefaultCodecs;
import io.r2dbc.h2.util.Assert;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.h2.message.DbException;
import reactor.core.publisher.Mono;

public final class H2ConnectionFactory
implements ConnectionFactory {
    private final Mono<? extends Client> clientFactory;

    public H2ConnectionFactory(H2ConnectionConfiguration configuration) {
        this((Mono<? extends Client>)Mono.fromSupplier(() -> H2ConnectionFactory.getSessionClient(configuration, false)));
    }

    public static CloseableConnectionFactory inMemory(String name) {
        return H2ConnectionFactory.inMemory(name, "sa", "");
    }

    public static CloseableConnectionFactory inMemory(String name, String username, CharSequence password) {
        return H2ConnectionFactory.inMemory(name, username, password, Collections.emptyMap());
    }

    public static CloseableConnectionFactory inMemory(String name, String username, CharSequence password, Map<H2ConnectionOption, String> properties) {
        Assert.requireNonNull(name, "name must not be null");
        Assert.requireNonNull(username, "username must not be null");
        Assert.requireNonNull(password, "password must not be null");
        Assert.requireNonNull(properties, "properties must not be null");
        H2ConnectionConfiguration.Builder builder = H2ConnectionConfiguration.builder().inMemory(name).username(username).password(password);
        for (Map.Entry<H2ConnectionOption, String> entry : properties.entrySet()) {
            builder.property(entry.getKey(), entry.getValue());
        }
        return new DefaultCloseableConnectionFactory(builder.build());
    }

    private static SessionClient getSessionClient(H2ConnectionConfiguration configuration, boolean shutdownDatabaseOnClose) {
        Assert.requireNonNull(configuration, "configuration must not be null");
        try {
            return new SessionClient(configuration.getConnectionInfo(), shutdownDatabaseOnClose);
        }
        catch (DbException e) {
            throw H2DatabaseExceptionFactory.convert(e);
        }
    }

    H2ConnectionFactory(Mono<? extends Client> clientFactory) {
        this.clientFactory = Assert.requireNonNull(clientFactory, "clientFactory must not be null");
    }

    public Mono<H2Connection> create() {
        return this.clientFactory.map(client -> new H2Connection((Client)client, new DefaultCodecs((Client)client)));
    }

    public H2ConnectionFactoryMetadata getMetadata() {
        return H2ConnectionFactoryMetadata.INSTANCE;
    }

    public String toString() {
        return "H2ConnectionFactory{clientFactory=" + this.clientFactory + '}';
    }

    private static class DefaultCloseableConnectionFactory
    implements CloseableConnectionFactory {
        private final H2ConnectionConfiguration configuration;
        private final Supplier<SessionClient> clientFactory;
        private volatile SessionClient persistentConnection;

        public DefaultCloseableConnectionFactory(H2ConnectionConfiguration configuration) {
            this.configuration = configuration;
            this.clientFactory = () -> H2ConnectionFactory.getSessionClient(configuration, false);
            this.persistentConnection = H2ConnectionFactory.getSessionClient(configuration, true);
        }

        @Override
        public Mono<Void> close() {
            return Mono.defer(() -> {
                SessionClient connection = this.persistentConnection;
                this.persistentConnection = null;
                if (connection != null) {
                    return connection.close();
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<H2Connection> create() {
            return Mono.fromSupplier(() -> {
                if (this.persistentConnection == null) {
                    throw new H2DatabaseExceptionFactory.H2R2dbcNonTransientResourceException(String.format("ConnectionFactory for %s is closed", this.configuration.getUrl()));
                }
                Client client = this.clientFactory.get();
                return new H2Connection(client, new DefaultCodecs(client));
            });
        }

        public ConnectionFactoryMetadata getMetadata() {
            return H2ConnectionFactoryMetadata.INSTANCE;
        }

        public String toString() {
            return "CloseableConnectionFactory{configuration=" + this.configuration + '}';
        }
    }
}

