/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2Result;
import io.r2dbc.h2.H2Statement;
import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.h2.util.Assert;
import io.r2dbc.spi.Batch;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;

public final class H2Batch
implements Batch {
    private final Client client;
    private final Codecs codecs;
    private final List<String> statements = new ArrayList<String>();

    H2Batch(Client client, Codecs codecs) {
        this.client = Assert.requireNonNull(client, "client must not be null");
        this.codecs = Assert.requireNonNull(codecs, "codecs must not be null");
    }

    public H2Batch add(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        this.statements.add(sql);
        return this;
    }

    public Flux<H2Result> execute() {
        return Flux.fromIterable(this.statements).flatMap(it -> new H2Statement(this.client, this.codecs, (String)it).doExecute(H2Statement.Bindings.EMPTY));
    }
}

