/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.client;

import io.r2dbc.h2.client.Binding;
import io.r2dbc.h2.util.Assert;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.h2.command.Command;
import org.h2.command.CommandInterface;
import org.h2.engine.Session;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import reactor.core.publisher.Mono;

public interface Client {
    public Mono<Void> close();

    public void disableAutoCommit();

    public void enableAutoCommit();

    default public void execute(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        Iterator<CommandInterface> iterator = this.prepareCommand(sql, Collections.emptyList());
        while (iterator.hasNext()) {
            CommandInterface command = iterator.next();
            this.update(command, false);
            if (!(command instanceof Command)) continue;
            ((Command)command).close();
        }
    }

    public boolean inTransaction();

    public Iterator<CommandInterface> prepareCommand(String var1, List<Binding> var2);

    public ResultInterface query(CommandInterface var1);

    public ResultWithGeneratedKeys update(CommandInterface var1, Object var2);

    public Session getSession();
}

