/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.BigIntegerCodec;
import io.r2dbc.mssql.codec.BinaryCodec;
import io.r2dbc.mssql.codec.BlobCodec;
import io.r2dbc.mssql.codec.BooleanCodec;
import io.r2dbc.mssql.codec.ByteCodec;
import io.r2dbc.mssql.codec.ClobCodec;
import io.r2dbc.mssql.codec.Codec;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.codec.DecimalCodec;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.codec.DoubleCodec;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.FloatCodec;
import io.r2dbc.mssql.codec.IntegerCodec;
import io.r2dbc.mssql.codec.LocalDateCodec;
import io.r2dbc.mssql.codec.LocalDateTimeCodec;
import io.r2dbc.mssql.codec.LocalTimeCodec;
import io.r2dbc.mssql.codec.LongCodec;
import io.r2dbc.mssql.codec.MoneyCodec;
import io.r2dbc.mssql.codec.OffsetDateTimeCodec;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.codec.ShortCodec;
import io.r2dbc.mssql.codec.StringCodec;
import io.r2dbc.mssql.codec.TimestampCodec;
import io.r2dbc.mssql.codec.UuidCodec;
import io.r2dbc.mssql.codec.ZonedDateTimeCodec;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.util.annotation.Nullable;

public final class DefaultCodecs
implements Codecs {
    private final Codec<?>[] codecs;
    private final Map<SqlServerType, Codec<?>> codecPreferences = new HashMap();
    private final Map<Class<?>, Codec<?>> codecNullCache = new ConcurrentHashMap();

    public DefaultCodecs() {
        this.codecs = Arrays.asList(StringCodec.INSTANCE, BinaryCodec.INSTANCE, BooleanCodec.INSTANCE, ByteCodec.INSTANCE, ShortCodec.INSTANCE, FloatCodec.INSTANCE, DoubleCodec.INSTANCE, IntegerCodec.INSTANCE, LongCodec.INSTANCE, BigIntegerCodec.INSTANCE, LocalTimeCodec.INSTANCE, LocalDateCodec.INSTANCE, LocalDateTimeCodec.INSTANCE, UuidCodec.INSTANCE, DecimalCodec.INSTANCE, MoneyCodec.INSTANCE, TimestampCodec.INSTANCE, OffsetDateTimeCodec.INSTANCE, ZonedDateTimeCodec.INSTANCE, BlobCodec.INSTANCE, ClobCodec.INSTANCE).toArray(new Codec[0]);
        this.codecPreferences.put(SqlServerType.BIT, BooleanCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.TINYINT, ByteCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.SMALLINT, ShortCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.INTEGER, IntegerCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.BIGINT, LongCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.REAL, FloatCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.FLOAT, DoubleCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.GUID, UuidCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.NUMERIC, DecimalCodec.INSTANCE);
        this.codecPreferences.put(SqlServerType.DECIMAL, DecimalCodec.INSTANCE);
    }

    @Override
    public Encoded encode(ByteBufAllocator allocator, RpcParameterContext context, Object value) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        Assert.requireNonNull(context, "RpcParameterContext must not be null");
        Assert.requireNonNull(value, "Value must not be null");
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncode(value)) continue;
            return codec.encode(allocator, context, value);
        }
        throw new IllegalArgumentException(String.format("Cannot encode [%s] parameter of type [%s]", value, value.getClass().getName()));
    }

    @Override
    public Encoded encodeNull(ByteBufAllocator allocator, Class<?> type) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        Codec codecToUse = this.codecNullCache.computeIfAbsent(type, key -> {
            for (Codec<?> codec : this.codecs) {
                if (!codec.canEncodeNull((Class<?>)key)) continue;
                return codec;
            }
            throw new IllegalArgumentException(String.format("Cannot encode [null] parameter of type [%s]", type.getName()));
        });
        return codecToUse.encodeNull(allocator);
    }

    @Override
    public <T> T decode(@Nullable ByteBuf buffer, Decodable decodable, Class<? extends T> type) {
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        if (buffer == null) {
            return null;
        }
        Codec<? extends T> codec = this.getDecodingCodec(decodable, type);
        return this.doDecode(codec, buffer, decodable, type);
    }

    @Nullable
    private <T> T doDecode(Codec<T> codec, @Nullable ByteBuf buffer, Decodable decodable, Class<? extends T> type) {
        return codec.decode(buffer, decodable, type);
    }

    @Override
    public Class<?> getJavaType(TypeInformation type) {
        Assert.requireNonNull(type, "Type must not be null");
        Codec<Object> decodingCodec = this.getDecodingCodec(new TypeInformationWrapper(type), Object.class);
        return decodingCodec.getType();
    }

    private <T> Codec<T> getDecodingCodec(Decodable decodable, Class<? extends T> requestedType) {
        Codec<T> preferredCodec = this.codecPreferences.get((Object)decodable.getType().getServerType());
        if (preferredCodec != null && preferredCodec.canDecode(decodable, requestedType)) {
            return preferredCodec;
        }
        for (Codec<T> codec : this.codecs) {
            if (!codec.canDecode(decodable, requestedType)) continue;
            return codec;
        }
        throw new IllegalArgumentException(String.format("Cannot decode value of type [%s], name [%s] server type [%s]", new Object[]{requestedType.getName(), decodable.getName(), decodable.getType().getServerType()}));
    }

    static class TypeInformationWrapper
    implements Decodable {
        private final TypeInformation typeInformation;

        TypeInformationWrapper(TypeInformation typeInformation) {
            this.typeInformation = typeInformation;
        }

        @Override
        public TypeInformation getType() {
            return this.typeInformation;
        }

        @Override
        public String getName() {
            return this.typeInformation.getServerTypeName();
        }
    }
}

