/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.netty.buffer.ByteBuf;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.tds.ServerCharset;
import io.r2dbc.mssql.util.Assert;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Collation {
    private static final LongObjectMap<Collation> COLLATIONS = new LongObjectHashMap();
    public static final Collation RAW = Collation.from(0, 0);
    private static final int UTF8_IN_TDSCOLLATION = 0x4000000;
    private static final Map<Integer, WindowsLocale> localeCache = new HashMap<Integer, WindowsLocale>();
    private static final Map<Integer, SortOrder> sortOrderCache;
    private final int lcid;
    private final int sortId;
    private final ServerCharset serverCharset;

    private Collation(int lcid, int sortId) throws UnsupportedEncodingException {
        this.lcid = lcid;
        this.sortId = sortId;
        this.serverCharset = lcid != 0 || sortId != 0 ? (0x4000000 == (lcid & 0x4000000) ? ServerCharset.UTF8 : (0 == sortId ? this.getEncodingFromLCID() : this.getEncodingFromSortId())) : ServerCharset.CP1252;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collation from(int lcid, int sortId) {
        long cacheKey = lcid | sortId << 4;
        LongObjectMap<Collation> longObjectMap = COLLATIONS;
        synchronized (longObjectMap) {
            Collation collation = (Collation)COLLATIONS.get(cacheKey);
            if (collation == null) {
                try {
                    collation = new Collation(lcid, sortId);
                }
                catch (UnsupportedEncodingException e) {
                    throw ProtocolException.unsupported(e);
                }
                COLLATIONS.put(cacheKey, (Object)collation);
            }
            return collation;
        }
    }

    public static Collation decode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Buffer must not be null");
        int info = Decode.asInt(buffer);
        int sortId = Decode.uByte(buffer);
        return Collation.from(info, sortId);
    }

    static int getLength() {
        return 5;
    }

    public void encode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        Encode.asInt(buffer, this.lcid);
        Encode.asByte(buffer, (byte)this.sortId);
    }

    public Charset getCharset() {
        return this.serverCharset.charset();
    }

    int getLCID() {
        return this.lcid;
    }

    int getSortId() {
        return this.sortId;
    }

    boolean supportsAsciiConversion() {
        return this.serverCharset.supportsAsciiConversion();
    }

    boolean hasAsciiCompatibleSBCS() {
        return this.serverCharset.hasAsciiCompatibleSBCS();
    }

    private int getLanguageId() {
        return this.lcid & 0xFFFF;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Collation)) {
            return false;
        }
        Collation collation = (Collation)o;
        return this.lcid == collation.lcid && this.sortId == collation.sortId;
    }

    public int hashCode() {
        return Objects.hash(this.lcid, this.sortId);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [encoding=").append((Object)this.serverCharset);
        sb.append(']');
        return sb.toString();
    }

    private ServerCharset getEncodingFromLCID() throws UnsupportedEncodingException {
        WindowsLocale locale = localeCache.get(this.getLanguageId());
        if (locale == null) {
            throw new UnsupportedEncodingException(String.format("Windows collation not supported: %s", Integer.toHexString(this.getLanguageId()).toUpperCase()));
        }
        try {
            return locale.getServerCharset();
        }
        catch (RuntimeException inner) {
            UnsupportedEncodingException e = new UnsupportedEncodingException(String.format("Windows collation not supported: %s", Integer.toHexString(this.getLanguageId()).toUpperCase()));
            e.initCause(inner);
            throw e;
        }
    }

    private ServerCharset getEncodingFromSortId() throws UnsupportedEncodingException {
        SortOrder sortOrder = sortOrderCache.get(this.sortId);
        if (sortOrder == null) {
            throw new UnsupportedEncodingException(String.format("SQL Server collation is not supported: %d", this.sortId));
        }
        try {
            return sortOrder.getServerCharset();
        }
        catch (RuntimeException inner) {
            UnsupportedEncodingException e = new UnsupportedEncodingException(String.format("SQL Server collation is not supported: %d", this.sortId));
            e.initCause(inner);
            throw e;
        }
    }

    static {
        for (WindowsLocale windowsLocale : WindowsLocale.values()) {
            localeCache.put(windowsLocale.langID, windowsLocale);
        }
        sortOrderCache = new HashMap<Integer, SortOrder>();
        for (Enum enum_ : SortOrder.values()) {
            sortOrderCache.put(((SortOrder)enum_).sortId, (SortOrder)enum_);
        }
    }

    static enum SortOrder {
        BIN_CP437(30, "SQL_Latin1_General_CP437_BIN", ServerCharset.CP437),
        DICTIONARY_437(31, "SQL_Latin1_General_CP437_CS_AS", ServerCharset.CP437),
        NOCASE_437(32, "SQL_Latin1_General_CP437_CI_AS", ServerCharset.CP437),
        NOCASEPREF_437(33, "SQL_Latin1_General_Pref_CP437_CI_AS", ServerCharset.CP437),
        NOACCENTS_437(34, "SQL_Latin1_General_CP437_CI_AI", ServerCharset.CP437),
        BIN2_CP437(35, "SQL_Latin1_General_CP437_BIN2", ServerCharset.CP437),
        BIN_CP850(40, "SQL_Latin1_General_CP850_BIN", ServerCharset.CP850),
        DICTIONARY_850(41, "SQL_Latin1_General_CP850_CS_AS", ServerCharset.CP850),
        NOCASE_850(42, "SQL_Latin1_General_CP850_CI_AS", ServerCharset.CP850),
        NOCASEPREF_850(43, "SQL_Latin1_General_Pref_CP850_CI_AS", ServerCharset.CP850),
        NOACCENTS_850(44, "SQL_Latin1_General_CP850_CI_AI", ServerCharset.CP850),
        BIN2_CP850(45, "SQL_Latin1_General_CP850_BIN2", ServerCharset.CP850),
        CASELESS_34(49, "SQL_1xCompat_CP850_CI_AS", ServerCharset.CP850),
        BIN_ISO_1(50, "bin_iso_1", ServerCharset.CP1252),
        DICTIONARY_ISO(51, "SQL_Latin1_General_CP1_CS_AS", ServerCharset.CP1252),
        NOCASE_ISO(52, "SQL_Latin1_General_CP1_CI_AS", ServerCharset.CP1252),
        NOCASEPREF_ISO(53, "SQL_Latin1_General_Pref_CP1_CI_AS", ServerCharset.CP1252),
        NOACCENTS_ISO(54, "SQL_Latin1_General_CP1_CI_AI", ServerCharset.CP1252),
        ALT_DICTIONARY(55, "SQL_AltDiction_CP850_CS_AS", ServerCharset.CP850),
        ALT_NOCASEPREF(56, "SQL_AltDiction_Pref_CP850_CI_AS", ServerCharset.CP850),
        ALT_NOACCENTS(57, "SQL_AltDiction_CP850_CI_AI", ServerCharset.CP850),
        SCAND_NOCASEPREF(58, "SQL_Scandinavian_Pref_CP850_CI_AS", ServerCharset.CP850),
        SCAND_DICTIONARY(59, "SQL_Scandinavian_CP850_CS_AS", ServerCharset.CP850),
        SCAND_NOCASE(60, "SQL_Scandinavian_CP850_CI_AS", ServerCharset.CP850),
        ALT_NOCASE(61, "SQL_AltDiction_CP850_CI_AS", ServerCharset.CP850),
        DICTIONARY_1252(71, "dictionary_1252", ServerCharset.CP1252),
        NOCASE_1252(72, "nocase_1252", ServerCharset.CP1252),
        DNK_NOR_DICTIONARY(73, "dnk_nor_dictionary", ServerCharset.CP1252),
        FIN_SWE_DICTIONARY(74, "fin_swe_dictionary", ServerCharset.CP1252),
        ISL_DICTIONARY(75, "isl_dictionary", ServerCharset.CP1252),
        BIN_CP1250(80, "bin_cp1250", ServerCharset.CP1250),
        DICTIONARY_1250(81, "SQL_Latin1_General_CP1250_CS_AS", ServerCharset.CP1250),
        NOCASE_1250(82, "SQL_Latin1_General_CP1250_CI_AS", ServerCharset.CP1250),
        CSYDIC(83, "SQL_Czech_CP1250_CS_AS", ServerCharset.CP1250),
        CSYNC(84, "SQL_Czech_CP1250_CI_AS", ServerCharset.CP1250),
        HUNDIC(85, "SQL_Hungarian_CP1250_CS_AS", ServerCharset.CP1250),
        HUNNC(86, "SQL_Hungarian_CP1250_CI_AS", ServerCharset.CP1250),
        PLKDIC(87, "SQL_Polish_CP1250_CS_AS", ServerCharset.CP1250),
        PLKNC(88, "SQL_Polish_CP1250_CI_AS", ServerCharset.CP1250),
        ROMDIC(89, "SQL_Romanian_CP1250_CS_AS", ServerCharset.CP1250),
        ROMNC(90, "SQL_Romanian_CP1250_CI_AS", ServerCharset.CP1250),
        SHLDIC(91, "SQL_Croatian_CP1250_CS_AS", ServerCharset.CP1250),
        SHLNC(92, "SQL_Croatian_CP1250_CI_AS", ServerCharset.CP1250),
        SKYDIC(93, "SQL_Slovak_CP1250_CS_AS", ServerCharset.CP1250),
        SKYNC(94, "SQL_Slovak_CP1250_CI_AS", ServerCharset.CP1250),
        SLVDIC(95, "SQL_Slovenian_CP1250_CS_AS", ServerCharset.CP1250),
        SLVNC(96, "SQL_Slovenian_CP1250_CI_AS", ServerCharset.CP1250),
        POLISH_CS(97, "polish_cs", ServerCharset.CP1250),
        POLISH_CI(98, "polish_ci", ServerCharset.CP1250),
        BIN_CP1251(104, "bin_cp1251", ServerCharset.CP1251),
        DICTIONARY_1251(105, "SQL_Latin1_General_CP1251_CS_AS", ServerCharset.CP1251),
        NOCASE_1251(106, "SQL_Latin1_General_CP1251_CI_AS", ServerCharset.CP1251),
        UKRDIC(107, "SQL_Ukrainian_CP1251_CS_AS", ServerCharset.CP1251),
        UKRNC(108, "SQL_Ukrainian_CP1251_CI_AS", ServerCharset.CP1251),
        BIN_CP1253(112, "bin_cp1253", ServerCharset.CP1253),
        DICTIONARY_1253(113, "SQL_Latin1_General_CP1253_CS_AS", ServerCharset.CP1253),
        NOCASE_1253(114, "SQL_Latin1_General_CP1253_CI_AS", ServerCharset.CP1253),
        GREEK_MIXEDDICTIONARY(120, "SQL_MixDiction_CP1253_CS_AS", ServerCharset.CP1253),
        GREEK_ALTDICTIONARY(121, "SQL_AltDiction_CP1253_CS_AS", ServerCharset.CP1253),
        GREEK_ALTDICTIONARY2(122, "SQL_AltDiction2_CP1253_CS_AS", ServerCharset.CP1253),
        GREEK_NOCASEDICT(124, "SQL_Latin1_General_CP1253_CI_AI", ServerCharset.CP1253),
        BIN_CP1254(128, "bin_cp1254", ServerCharset.CP1254),
        DICTIONARY_1254(129, "SQL_Latin1_General_CP1254_CS_AS", ServerCharset.CP1254),
        NOCASE_1254(130, "SQL_Latin1_General_CP1254_CI_AS", ServerCharset.CP1254),
        BIN_CP1255(136, "bin_cp1255", ServerCharset.CP1255),
        DICTIONARY_1255(137, "SQL_Latin1_General_CP1255_CS_AS", ServerCharset.CP1255),
        NOCASE_1255(138, "SQL_Latin1_General_CP1255_CI_AS", ServerCharset.CP1255),
        BIN_CP1256(144, "bin_cp1256", ServerCharset.CP1256),
        DICTIONARY_1256(145, "SQL_Latin1_General_CP1256_CS_AS", ServerCharset.CP1256),
        NOCASE_1256(146, "SQL_Latin1_General_CP1256_CI_AS", ServerCharset.CP1256),
        BIN_CP1257(152, "bin_cp1257", ServerCharset.CP1257),
        DICTIONARY_1257(153, "SQL_Latin1_General_CP1257_CS_AS", ServerCharset.CP1257),
        NOCASE_1257(154, "SQL_Latin1_General_CP1257_CI_AS", ServerCharset.CP1257),
        ETIDIC(155, "SQL_Estonian_CP1257_CS_AS", ServerCharset.CP1257),
        ETINC(156, "SQL_Estonian_CP1257_CI_AS", ServerCharset.CP1257),
        LVIDIC(157, "SQL_Latvian_CP1257_CS_AS", ServerCharset.CP1257),
        LVINC(158, "SQL_Latvian_CP1257_CI_AS", ServerCharset.CP1257),
        LTHDIC(159, "SQL_Lithuanian_CP1257_CS_AS", ServerCharset.CP1257),
        LTHNC(160, "SQL_Lithuanian_CP1257_CI_AS", ServerCharset.CP1257),
        DANNO_NOCASEPREF(183, "SQL_Danish_Pref_CP1_CI_AS", ServerCharset.CP1252),
        SVFI1_NOCASEPREF(184, "SQL_SwedishPhone_Pref_CP1_CI_AS", ServerCharset.CP1252),
        SVFI2_NOCASEPREF(185, "SQL_SwedishStd_Pref_CP1_CI_AS", ServerCharset.CP1252),
        ISLAN_NOCASEPREF(186, "SQL_Icelandic_Pref_CP1_CI_AS", ServerCharset.CP1252),
        BIN_CP932(192, "bin_cp932", ServerCharset.CP932),
        NLS_CP932(193, "nls_cp932", ServerCharset.CP932),
        BIN_CP949(194, "bin_cp949", ServerCharset.CP949),
        NLS_CP949(195, "nls_cp949", ServerCharset.CP949),
        BIN_CP950(196, "bin_cp950", ServerCharset.CP950),
        NLS_CP950(197, "nls_cp950", ServerCharset.CP950),
        BIN_CP936(198, "bin_cp936", ServerCharset.CP936),
        NLS_CP936(199, "nls_cp936", ServerCharset.CP936),
        NLS_CP932_CS(200, "nls_cp932_cs", ServerCharset.CP932),
        NLS_CP949_CS(201, "nls_cp949_cs", ServerCharset.CP949),
        NLS_CP950_CS(202, "nls_cp950_cs", ServerCharset.CP950),
        NLS_CP936_CS(203, "nls_cp936_cs", ServerCharset.CP936),
        BIN_CP874(204, "bin_cp874", ServerCharset.CP874),
        NLS_CP874(205, "nls_cp874", ServerCharset.CP874),
        NLS_CP874_CS(206, "nls_cp874_cs", ServerCharset.CP874),
        EBCDIC_037(210, "SQL_EBCDIC037_CP1_CS_AS", ServerCharset.CP1252),
        EBCDIC_273(211, "SQL_EBCDIC273_CP1_CS_AS", ServerCharset.CP1252),
        EBCDIC_277(212, "SQL_EBCDIC277_CP1_CS_AS", ServerCharset.CP1252),
        EBCDIC_278(213, "SQL_EBCDIC278_CP1_CS_AS", ServerCharset.CP1252),
        EBCDIC_280(214, "SQL_EBCDIC280_CP1_CS_AS", ServerCharset.CP1252),
        EBCDIC_284(215, "SQL_EBCDIC284_CP1_CS_AS", ServerCharset.CP1252),
        EBCDIC_285(216, "SQL_EBCDIC285_CP1_CS_AS", ServerCharset.CP1252),
        EBCDIC_297(217, "SQL_EBCDIC297_CP1_CS_AS", ServerCharset.CP1252);

        private final int sortId;
        private final String name;
        private final ServerCharset serverCharset;

        private SortOrder(int sortId, String name, ServerCharset serverCharset) {
            this.sortId = sortId;
            this.name = name;
            this.serverCharset = serverCharset;
        }

        ServerCharset getServerCharset() {
            this.serverCharset.charset();
            return this.serverCharset;
        }

        public final String toString() {
            return this.name;
        }
    }

    static enum WindowsLocale {
        ar_SA(1025, ServerCharset.CP1256),
        bg_BG(1026, ServerCharset.CP1251),
        ca_ES(1027, ServerCharset.CP1252),
        zh_TW(1028, ServerCharset.CP950),
        cs_CZ(1029, ServerCharset.CP1250),
        da_DK(1030, ServerCharset.CP1252),
        de_DE(1031, ServerCharset.CP1252),
        el_GR(1032, ServerCharset.CP1253),
        en_US(1033, ServerCharset.CP1252),
        es_ES_tradnl(1034, ServerCharset.CP1252),
        fi_FI(1035, ServerCharset.CP1252),
        fr_FR(1036, ServerCharset.CP1252),
        he_IL(1037, ServerCharset.CP1255),
        hu_HU(1038, ServerCharset.CP1250),
        is_IS(1039, ServerCharset.CP1252),
        it_IT(1040, ServerCharset.CP1252),
        ja_JP(1041, ServerCharset.CP932),
        ko_KR(1042, ServerCharset.CP949),
        nl_NL(1043, ServerCharset.CP1252),
        nb_NO(1044, ServerCharset.CP1252),
        pl_PL(1045, ServerCharset.CP1250),
        pt_BR(1046, ServerCharset.CP1252),
        rm_CH(1047, ServerCharset.CP1252),
        ro_RO(1048, ServerCharset.CP1250),
        ru_RU(1049, ServerCharset.CP1251),
        hr_HR(1050, ServerCharset.CP1250),
        sk_SK(1051, ServerCharset.CP1250),
        sq_AL(1052, ServerCharset.CP1250),
        sv_SE(1053, ServerCharset.CP1252),
        th_TH(1054, ServerCharset.CP874),
        tr_TR(1055, ServerCharset.CP1254),
        ur_PK(1056, ServerCharset.CP1256),
        id_ID(1057, ServerCharset.CP1252),
        uk_UA(1058, ServerCharset.CP1251),
        be_BY(1059, ServerCharset.CP1251),
        sl_SI(1060, ServerCharset.CP1250),
        et_EE(1061, ServerCharset.CP1257),
        lv_LV(1062, ServerCharset.CP1257),
        lt_LT(1063, ServerCharset.CP1257),
        tg_Cyrl_TJ(1064, ServerCharset.CP1251),
        fa_IR(1065, ServerCharset.CP1256),
        vi_VN(1066, ServerCharset.CP1258),
        hy_AM(1067, ServerCharset.CP1252),
        az_Latn_AZ(1068, ServerCharset.CP1254),
        eu_ES(1069, ServerCharset.CP1252),
        wen_DE(1070, ServerCharset.CP1252),
        mk_MK(1071, ServerCharset.CP1251),
        tn_ZA(1074, ServerCharset.CP1252),
        xh_ZA(1076, ServerCharset.CP1252),
        zu_ZA(1077, ServerCharset.CP1252),
        Af_ZA(1078, ServerCharset.CP1252),
        ka_GE(1079, ServerCharset.CP1252),
        fo_FO(1080, ServerCharset.CP1252),
        hi_IN(1081, ServerCharset.UNICODE),
        mt_MT(1082, ServerCharset.UNICODE),
        se_NO(1083, ServerCharset.CP1252),
        ms_MY(1086, ServerCharset.CP1252),
        kk_KZ(1087, ServerCharset.CP1251),
        ky_KG(1088, ServerCharset.CP1251),
        sw_KE(1089, ServerCharset.CP1252),
        tk_TM(1090, ServerCharset.CP1250),
        uz_Latn_UZ(1091, ServerCharset.CP1254),
        tt_RU(1092, ServerCharset.CP1251),
        bn_IN(1093, ServerCharset.UNICODE),
        pa_IN(1094, ServerCharset.UNICODE),
        gu_IN(1095, ServerCharset.UNICODE),
        or_IN(1096, ServerCharset.UNICODE),
        ta_IN(1097, ServerCharset.UNICODE),
        te_IN(1098, ServerCharset.UNICODE),
        kn_IN(1099, ServerCharset.UNICODE),
        ml_IN(1100, ServerCharset.UNICODE),
        as_IN(1101, ServerCharset.UNICODE),
        mr_IN(1102, ServerCharset.UNICODE),
        sa_IN(1103, ServerCharset.UNICODE),
        mn_MN(1104, ServerCharset.CP1251),
        bo_CN(1105, ServerCharset.UNICODE),
        cy_GB(1106, ServerCharset.CP1252),
        km_KH(1107, ServerCharset.UNICODE),
        lo_LA(1108, ServerCharset.UNICODE),
        gl_ES(1110, ServerCharset.CP1252),
        kok_IN(1111, ServerCharset.UNICODE),
        syr_SY(1114, ServerCharset.UNICODE),
        si_LK(1115, ServerCharset.UNICODE),
        iu_Cans_CA(1117, ServerCharset.CP1252),
        am_ET(1118, ServerCharset.CP1252),
        ne_NP(1121, ServerCharset.UNICODE),
        fy_NL(1122, ServerCharset.CP1252),
        ps_AF(1123, ServerCharset.UNICODE),
        fil_PH(1124, ServerCharset.CP1252),
        dv_MV(1125, ServerCharset.UNICODE),
        ha_Latn_NG(1128, ServerCharset.CP1252),
        yo_NG(1130, ServerCharset.CP1252),
        quz_BO(1131, ServerCharset.CP1252),
        nso_ZA(1132, ServerCharset.CP1252),
        ba_RU(1133, ServerCharset.CP1251),
        lb_LU(1134, ServerCharset.CP1252),
        kl_GL(1135, ServerCharset.CP1252),
        ig_NG(1136, ServerCharset.CP1252),
        ii_CN(1144, ServerCharset.CP1252),
        arn_CL(1146, ServerCharset.CP1252),
        moh_CA(1148, ServerCharset.CP1252),
        br_FR(1150, ServerCharset.CP1252),
        ug_CN(1152, ServerCharset.CP1256),
        mi_NZ(1153, ServerCharset.UNICODE),
        oc_FR(1154, ServerCharset.CP1252),
        co_FR(1155, ServerCharset.CP1252),
        gsw_FR(1156, ServerCharset.CP1252),
        sah_RU(1157, ServerCharset.CP1251),
        qut_GT(1158, ServerCharset.CP1252),
        rw_RW(1159, ServerCharset.CP1252),
        wo_SN(1160, ServerCharset.CP1252),
        prs_AF(1164, ServerCharset.CP1256),
        ar_IQ(2049, ServerCharset.CP1256),
        zh_CN(2052, ServerCharset.CP936),
        de_CH(2055, ServerCharset.CP1252),
        en_GB(2057, ServerCharset.CP1252),
        es_MX(2058, ServerCharset.CP1252),
        fr_BE(2060, ServerCharset.CP1252),
        it_CH(2064, ServerCharset.CP1252),
        nl_BE(2067, ServerCharset.CP1252),
        nn_NO(2068, ServerCharset.CP1252),
        pt_PT(2070, ServerCharset.CP1252),
        sr_Latn_CS(2074, ServerCharset.CP1250),
        sv_FI(2077, ServerCharset.CP1252),
        Lithuanian_Classic(2087, ServerCharset.CP1257),
        az_Cyrl_AZ(2092, ServerCharset.CP1251),
        dsb_DE(2094, ServerCharset.CP1252),
        se_SE(2107, ServerCharset.CP1252),
        ga_IE(2108, ServerCharset.CP1252),
        ms_BN(2110, ServerCharset.CP1252),
        uz_Cyrl_UZ(2115, ServerCharset.CP1251),
        bn_BD(2117, ServerCharset.UNICODE),
        mn_Mong_CN(2128, ServerCharset.CP1251),
        iu_Latn_CA(2141, ServerCharset.CP1252),
        tzm_Latn_DZ(2143, ServerCharset.CP1252),
        quz_EC(2155, ServerCharset.CP1252),
        ar_EG(3073, ServerCharset.CP1256),
        zh_HK(3076, ServerCharset.CP950),
        de_AT(3079, ServerCharset.CP1252),
        en_AU(3081, ServerCharset.CP1252),
        es_ES(3082, ServerCharset.CP1252),
        fr_CA(3084, ServerCharset.CP1252),
        sr_Cyrl_CS(3098, ServerCharset.CP1251),
        se_FI(3131, ServerCharset.CP1252),
        quz_PE(3179, ServerCharset.CP1252),
        ar_LY(4097, ServerCharset.CP1256),
        zh_SG(4100, ServerCharset.CP936),
        de_LU(4103, ServerCharset.CP1252),
        en_CA(4105, ServerCharset.CP1252),
        es_GT(4106, ServerCharset.CP1252),
        fr_CH(4108, ServerCharset.CP1252),
        hr_BA(4122, ServerCharset.CP1250),
        smj_NO(4155, ServerCharset.CP1252),
        ar_DZ(5121, ServerCharset.CP1256),
        zh_MO(5124, ServerCharset.CP950),
        de_LI(5127, ServerCharset.CP1252),
        en_NZ(5129, ServerCharset.CP1252),
        es_CR(5130, ServerCharset.CP1252),
        fr_LU(5132, ServerCharset.CP1252),
        bs_Latn_BA(5146, ServerCharset.CP1250),
        smj_SE(5179, ServerCharset.CP1252),
        ar_MA(6145, ServerCharset.CP1256),
        en_IE(6153, ServerCharset.CP1252),
        es_PA(6154, ServerCharset.CP1252),
        fr_MC(6156, ServerCharset.CP1252),
        sr_Latn_BA(6170, ServerCharset.CP1250),
        sma_NO(6203, ServerCharset.CP1252),
        ar_TN(7169, ServerCharset.CP1256),
        en_ZA(7177, ServerCharset.CP1252),
        es_DO(7178, ServerCharset.CP1252),
        sr_Cyrl_BA(7194, ServerCharset.CP1251),
        sma_SB(7227, ServerCharset.CP1252),
        ar_OM(8193, ServerCharset.CP1256),
        en_JM(8201, ServerCharset.CP1252),
        es_VE(8202, ServerCharset.CP1252),
        bs_Cyrl_BA(8218, ServerCharset.CP1251),
        sms_FI(8251, ServerCharset.CP1252),
        ar_YE(9217, ServerCharset.CP1256),
        en_CB(9225, ServerCharset.CP1252),
        es_CO(9226, ServerCharset.CP1252),
        smn_FI(9275, ServerCharset.CP1252),
        ar_SY(10241, ServerCharset.CP1256),
        en_BZ(10249, ServerCharset.CP1252),
        es_PE(10250, ServerCharset.CP1252),
        ar_JO(11265, ServerCharset.CP1256),
        en_TT(11273, ServerCharset.CP1252),
        es_AR(11274, ServerCharset.CP1252),
        ar_LB(12289, ServerCharset.CP1256),
        en_ZW(12297, ServerCharset.CP1252),
        es_EC(12298, ServerCharset.CP1252),
        ar_KW(13313, ServerCharset.CP1256),
        en_PH(13321, ServerCharset.CP1252),
        es_CL(13322, ServerCharset.CP1252),
        ar_AE(14337, ServerCharset.CP1256),
        es_UY(14346, ServerCharset.CP1252),
        ar_BH(15361, ServerCharset.CP1256),
        es_PY(15370, ServerCharset.CP1252),
        ar_QA(16385, ServerCharset.CP1256),
        en_IN(16393, ServerCharset.CP1252),
        es_BO(16394, ServerCharset.CP1252),
        en_MY(17417, ServerCharset.CP1252),
        es_SV(17418, ServerCharset.CP1252),
        en_SG(18441, ServerCharset.CP1252),
        es_HN(18442, ServerCharset.CP1252),
        es_NI(19466, ServerCharset.CP1252),
        es_PR(20490, ServerCharset.CP1252),
        es_US(21514, ServerCharset.CP1252);

        private final int langID;
        private final ServerCharset serverCharset;

        private WindowsLocale(int langID, ServerCharset serverCharset) {
            this.langID = langID;
            this.serverCharset = serverCharset;
        }

        ServerCharset getServerCharset() {
            this.serverCharset.charset();
            return this.serverCharset;
        }
    }
}

