/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.token.Column;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import javax.annotation.Nonnull;

public final class MssqlColumnMetadata
implements ColumnMetadata {
    private final Column column;
    private final Codecs codecs;

    MssqlColumnMetadata(Column column, Codecs codecs) {
        this.column = Assert.requireNonNull(column, "Column must not be null");
        this.codecs = Assert.requireNonNull(codecs, "Codecs must not be null");
    }

    public String getName() {
        return this.column.getName();
    }

    public Integer getPrecision() {
        return this.getNativeTypeMetadata().getPrecision();
    }

    public Integer getScale() {
        return this.getNativeTypeMetadata().getScale();
    }

    public Nullability getNullability() {
        return this.getNativeTypeMetadata().isNullable() ? Nullability.NULLABLE : Nullability.NON_NULL;
    }

    public Class<?> getJavaType() {
        return this.codecs.getJavaType(this.getNativeTypeMetadata());
    }

    @Nonnull
    public TypeInformation getNativeTypeMetadata() {
        return this.column.getType();
    }
}

