/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.Codec;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import reactor.util.annotation.Nullable;

abstract class AbstractCodec<T>
implements Codec<T> {
    private final Class<T> type;

    AbstractCodec(Class<T> type) {
        this.type = Assert.requireNonNull(type, "Type must not be null");
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "Value must not be null");
        return this.type.isInstance(value);
    }

    @Override
    public final Encoded encode(ByteBufAllocator allocator, RpcParameterContext context, T value) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        Assert.requireNonNull(context, "RpcParameterContext must not be null");
        Assert.requireNonNull(value, "Value must not be null");
        return this.doEncode(allocator, context, value);
    }

    @Override
    public final boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "Type must not be null");
        return this.type.isAssignableFrom(type);
    }

    @Override
    public final Encoded encodeNull(ByteBufAllocator allocator) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        return this.doEncodeNull(allocator);
    }

    @Override
    public final boolean canDecode(Decodable decodable, Class<?> type) {
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        return type.isAssignableFrom(this.type) && this.doCanDecode(decodable.getType());
    }

    @Override
    @Nullable
    public T decode(@Nullable ByteBuf buffer, Decodable decodable, Class<? extends T> type) {
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        if (buffer == null) {
            return null;
        }
        Length length = Length.decode(buffer, decodable.getType());
        return this.doDecode(buffer, length, decodable.getType(), type);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    abstract Encoded doEncode(ByteBufAllocator var1, RpcParameterContext var2, T var3);

    abstract Encoded doEncodeNull(ByteBufAllocator var1);

    abstract boolean doCanDecode(TypeInformation var1);

    @Nullable
    abstract T doDecode(ByteBuf var1, Length var2, TypeInformation var3, Class<? extends T> var4);
}

