/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.Set;

abstract class AbstractNumericCodec<T>
extends AbstractCodec<T> {
    static final int SIZE_BIGINT = 8;
    static final int SIZE_INT = 4;
    static final int SIZE_SMALL_INT = 2;
    static final int SIZE_TINY_INT = 1;
    private static final Set<SqlServerType> SUPPORTED_TYPES = EnumSet.of(SqlServerType.BIT, new SqlServerType[]{SqlServerType.TINYINT, SqlServerType.SMALLINT, SqlServerType.INTEGER, SqlServerType.BIGINT, SqlServerType.DECIMAL, SqlServerType.NUMERIC});
    private final LongToObjectFunction<T> converter;

    AbstractNumericCodec(Class<T> type, LongToObjectFunction<T> converter) {
        super(type);
        this.converter = converter;
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return SUPPORTED_TYPES.contains((Object)typeInformation.getServerType());
    }

    @Override
    T doDecode(ByteBuf buffer, Length length, TypeInformation typeInformation, Class<? extends T> valueType) {
        if (length.isNull()) {
            return null;
        }
        if (typeInformation.getServerType() == SqlServerType.DECIMAL || typeInformation.getServerType() == SqlServerType.NUMERIC) {
            return this.converter.apply(AbstractNumericCodec.decodeDecimal(buffer, length.getLength(), typeInformation.getScale()).longValue());
        }
        switch (length.getLength()) {
            case 8: {
                return this.converter.apply(Decode.bigint(buffer));
            }
            case 4: {
                return this.converter.apply(Decode.asInt(buffer));
            }
            case 2: {
                return this.converter.apply(Decode.smallInt(buffer));
            }
            case 1: {
                return this.converter.apply(Decode.tinyInt(buffer));
            }
        }
        throw ProtocolException.invalidTds(String.format("Unexpected value length: %d", length.getLength()));
    }

    static BigDecimal decodeDecimal(ByteBuf buffer, int length, int scale) {
        byte signByte = buffer.readByte();
        int sign = 0 == signByte ? -1 : 1;
        byte[] magnitude = new byte[length - 1];
        for (int i = 0; i < magnitude.length; ++i) {
            magnitude[magnitude.length - 1 - i] = buffer.readByte();
        }
        return new BigDecimal(new BigInteger(sign, magnitude), scale);
    }

    @FunctionalInterface
    static interface LongToObjectFunction<T> {
        public T apply(long var1);
    }
}

