/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.type.AbstractTypeDecoderStrategy;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.MutableTypeInformation;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeBuilder;
import io.r2dbc.mssql.message.type.TypeDecoderStrategy;
import io.r2dbc.mssql.message.type.TypeUtils;

interface TypeDecoderStrategies {
    public static TypeDecoderStrategy bigOrSmall(TypeBuilder big, TypeBuilder small) {
        return new BigOrSmallByteLenStrategy(big, small);
    }

    public static TypeDecoderStrategy create(SqlServerType serverType, int maxLength, int precision, int displaySize, int scale) {
        return new FixedLenStrategy(serverType, maxLength, precision, displaySize, scale);
    }

    public static TypeDecoderStrategy decimalNumeric(SqlServerType serverType) {
        return new DecimalNumericStrategy(serverType);
    }

    public static TypeDecoderStrategy temporal(SqlServerType serverType) {
        return new KatmaiScaledTemporalStrategy(serverType);
    }

    public static class KatmaiScaledTemporalStrategy
    extends AbstractTypeDecoderStrategy {
        private final SqlServerType serverType;

        KatmaiScaledTemporalStrategy(SqlServerType serverType) {
            super(1);
            this.serverType = serverType;
        }

        private int getPrecision(String baseFormat, int scale) {
            return baseFormat.length() + (scale > 0 ? 1 + scale : 0);
        }

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.scale = Decode.uByte(buffer);
            if (typeInfo.scale > 7) {
                throw ProtocolException.invalidTds(String.format("Unsupported temporal scale: %d", typeInfo.scale));
            }
            switch (this.serverType) {
                case TIME: {
                    typeInfo.precision = this.getPrecision("hh:mm:ss", typeInfo.scale);
                    typeInfo.maxLength = TypeUtils.getTimeValueLength(typeInfo.scale);
                    break;
                }
                case DATETIME2: {
                    typeInfo.precision = this.getPrecision("yyyy-mm-dd hh:mm:ss", typeInfo.scale);
                    typeInfo.maxLength = TypeUtils.getDateTimeValueLength(typeInfo.scale);
                    break;
                }
                case DATETIMEOFFSET: {
                    typeInfo.precision = this.getPrecision("yyyy-mm-dd hh:mm:ss +HH:MM", typeInfo.scale);
                    typeInfo.maxLength = TypeUtils.getDatetimeoffsetValueLength(typeInfo.scale);
                    break;
                }
                default: {
                    throw ProtocolException.invalidTds(String.format("Unexpected SQL Server type: %s", new Object[]{this.serverType}));
                }
            }
            typeInfo.lengthStrategy = LengthStrategy.BYTELENTYPE;
            typeInfo.serverType = this.serverType;
            typeInfo.displaySize = typeInfo.precision;
        }
    }

    public static class BigOrSmallByteLenStrategy
    extends AbstractTypeDecoderStrategy {
        private final TypeBuilder bigBuilder;
        private final TypeBuilder smallBuilder;

        BigOrSmallByteLenStrategy(TypeBuilder bigBuilder, TypeBuilder smallBuilder) {
            super(1);
            this.bigBuilder = bigBuilder;
            this.smallBuilder = smallBuilder;
        }

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            int length = Decode.uByte(buffer);
            switch (length) {
                case 8: {
                    this.bigBuilder.build(typeInfo, buffer);
                    break;
                }
                case 4: {
                    this.smallBuilder.build(typeInfo, buffer);
                    break;
                }
                default: {
                    throw ProtocolException.invalidTds(String.format("Unsupported length for Big/Small strategy: %d", length));
                }
            }
            typeInfo.lengthStrategy = LengthStrategy.BYTELENTYPE;
        }
    }

    public static class DecimalNumericStrategy
    extends AbstractTypeDecoderStrategy {
        private final SqlServerType serverType;

        DecimalNumericStrategy(SqlServerType serverType) {
            super(3);
            this.serverType = serverType;
        }

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            int maxLength = Decode.uByte(buffer);
            int precision = Decode.uByte(buffer);
            int scale = Decode.uByte(buffer);
            if (maxLength > 17) {
                throw ProtocolException.invalidTds(String.format("Invalid maximal length for decimal number type: %d", maxLength));
            }
            typeInfo.lengthStrategy = LengthStrategy.BYTELENTYPE;
            typeInfo.serverType = this.serverType;
            typeInfo.maxLength = maxLength;
            typeInfo.precision = precision;
            typeInfo.displaySize = precision + 2;
            typeInfo.scale = scale;
        }
    }

    public static class FixedLenStrategy
    extends AbstractTypeDecoderStrategy {
        private final SqlServerType serverType;
        private final int maxLength;
        private final int precision;
        private final int displaySize;
        private final int scale;

        FixedLenStrategy(SqlServerType serverType, int maxLength, int precision, int displaySize, int scale) {
            super(0);
            this.serverType = serverType;
            this.maxLength = maxLength;
            this.precision = precision;
            this.displaySize = displaySize;
            this.scale = scale;
        }

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.lengthStrategy = LengthStrategy.FIXEDLENTYPE;
            typeInfo.serverType = this.serverType;
            typeInfo.maxLength = this.maxLength;
            typeInfo.precision = this.precision;
            typeInfo.displaySize = this.displaySize;
            typeInfo.scale = this.scale;
        }
    }
}

