/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.netty.util.ReferenceCountUtil;
import io.r2dbc.mssql.ExceptionFactory;
import io.r2dbc.mssql.MssqlRow;
import io.r2dbc.mssql.MssqlRowMetadata;
import io.r2dbc.mssql.client.ConnectionContext;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.token.AbstractDoneToken;
import io.r2dbc.mssql.message.token.ColumnMetadataToken;
import io.r2dbc.mssql.message.token.ErrorToken;
import io.r2dbc.mssql.message.token.NbcRowToken;
import io.r2dbc.mssql.message.token.RowToken;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class MssqlResult
implements Result {
    private static final Logger LOGGER = Loggers.getLogger(MssqlResult.class);
    public static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private final String sql;
    private final ConnectionContext context;
    private final Codecs codecs;
    private final Flux<Message> messages;
    private volatile MssqlRowMetadata rowMetadata;
    private volatile RuntimeException throwable;

    private MssqlResult(String sql, ConnectionContext context, Codecs codecs, Flux<Message> messages) {
        this.sql = sql;
        this.context = context;
        this.codecs = codecs;
        this.messages = messages;
    }

    static MssqlResult toResult(String sql, ConnectionContext context, Codecs codecs, Flux<Message> messages) {
        Assert.requireNonNull(sql, "SQL must not be null");
        Assert.requireNonNull(codecs, "Codecs must not be null");
        Assert.requireNonNull(context, "ConnectionContext must not be null");
        Assert.requireNonNull(messages, "Messages must not be null");
        LOGGER.debug(context.getMessage("Creating new result"));
        return new MssqlResult(sql, context, codecs, messages);
    }

    public Mono<Integer> getRowsUpdated() {
        return this.messages.handle((message, sink) -> {
            AbstractDoneToken doneToken;
            if (message instanceof AbstractDoneToken && (doneToken = (AbstractDoneToken)message).hasCount()) {
                if (DEBUG_ENABLED) {
                    LOGGER.debug(this.context.getMessage("Incoming row count: {}"), new Object[]{doneToken});
                }
                sink.next((Object)doneToken.getRowCount());
            }
            if (message instanceof ErrorToken) {
                R2dbcException mssqlException = ExceptionFactory.createException((ErrorToken)message, this.sql);
                RuntimeException exception = this.throwable;
                if (exception != null) {
                    exception.addSuppressed((Throwable)mssqlException);
                } else {
                    this.throwable = mssqlException;
                }
                return;
            }
            ReferenceCountUtil.release((Object)message);
        }).doOnComplete(() -> {
            RuntimeException exception = this.throwable;
            if (exception != null) {
                throw exception;
            }
        }).reduce(Long::sum).map(Long::intValue);
    }

    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        Assert.requireNonNull(f, "Mapping function must not be null");
        return this.messages.handle((message, sink) -> {
            if (message.getClass() == ColumnMetadataToken.class) {
                ColumnMetadataToken token = (ColumnMetadataToken)message;
                if (!token.hasColumns()) {
                    return;
                }
                if (DEBUG_ENABLED) {
                    LOGGER.debug(this.context.getMessage("Result column definition: {}"), new Object[]{message});
                }
                this.rowMetadata = MssqlRowMetadata.create(this.codecs, token);
                return;
            }
            if (message.getClass() == RowToken.class || message.getClass() == NbcRowToken.class) {
                MssqlRowMetadata rowMetadata = this.rowMetadata;
                if (rowMetadata == null) {
                    sink.error((Throwable)new IllegalStateException("No MssqlRowMetadata available"));
                    return;
                }
                MssqlRow row = MssqlRow.toRow(this.codecs, (RowToken)message, rowMetadata);
                try {
                    sink.next(f.apply(row, row.getMetadata()));
                }
                finally {
                    row.release();
                }
                return;
            }
            if (message instanceof ErrorToken) {
                R2dbcException mssqlException = ExceptionFactory.createException((ErrorToken)message, this.sql);
                RuntimeException exception = this.throwable;
                if (exception != null) {
                    exception.addSuppressed((Throwable)mssqlException);
                } else {
                    this.throwable = mssqlException;
                }
                return;
            }
            ReferenceCountUtil.release((Object)message);
        }).doOnComplete(() -> {
            RuntimeException exception = this.throwable;
            if (exception != null) {
                throw exception;
            }
        });
    }
}

