/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractNumericCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.SqlServerType;

final class BooleanCodec
extends AbstractNumericCodec<Boolean> {
    static final BooleanCodec INSTANCE = new BooleanCodec();
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeNull(alloc, SqlServerType.TINYINT));

    private BooleanCodec() {
        super(Boolean.class, value -> value != 0L);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, Boolean value) {
        return RpcEncoding.encodeFixed(allocator, SqlServerType.TINYINT, value, (buffer, b) -> Encode.asByte(buffer, b != false ? 1 : 0));
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.TINYINT);
    }
}

