/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.message.type.TypeUtils;
import io.r2dbc.mssql.util.Assert;
import java.time.LocalTime;

final class LocalTimeCodec
extends AbstractCodec<LocalTime> {
    public static final LocalTimeCodec INSTANCE = new LocalTimeCodec();
    private static final int[] SCALED_MULTIPLIERS = new int[]{10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeTemporalNull(alloc, SqlServerType.TIME, 7));

    private LocalTimeCodec() {
        super(LocalTime.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, LocalTime value) {
        return RpcEncoding.encode(allocator, SqlServerType.TIME, TypeUtils.getTimeValueLength(7), value, (buffer, localTime) -> LocalTimeCodec.doEncode(buffer, 7, localTime));
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.TIME);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return typeInformation.getServerType() == SqlServerType.TIME;
    }

    @Override
    LocalTime doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends LocalTime> valueType) {
        if (length.isNull()) {
            return null;
        }
        long hundredNanosSinceMidnight = 0L;
        int scale = type.getScale();
        Assert.isTrue(scale >= 0 && scale <= 7, "Invalid fractional scale");
        int valueLength = TypeUtils.getTimeValueLength(scale);
        for (int i = 0; i < valueLength; ++i) {
            hundredNanosSinceMidnight |= ((long)buffer.readByte() & 0xFFL) << 8 * i;
        }
        return LocalTime.ofNanoOfDay((hundredNanosSinceMidnight *= (long)SCALED_MULTIPLIERS[scale]) * 100L);
    }

    static void doEncode(ByteBuf buffer, int scale, LocalTime value) {
        int valueLength = TypeUtils.getTimeValueLength(scale);
        LocalTimeCodec.doEncodeValue(buffer, valueLength, value);
    }

    private static void doEncodeValue(ByteBuf buffer, int valueLength, LocalTime value) {
        long nanosSinceMidnight = value.toNanoOfDay();
        nanosSinceMidnight /= (long)SCALED_MULTIPLIERS[valueLength];
        for (int i = 0; i < valueLength; ++i) {
            buffer.writeByte((int)((byte)(nanosSinceMidnight >> 8 * i & 0xFFL)));
        }
    }
}

