/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.util;

import io.r2dbc.mssql.util.Assert;
import java.util.Arrays;
import java.util.function.Predicate;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static <T> Predicate<T> not(Predicate<T> t) {
        Assert.requireNonNull(t, "t must not be null");
        return t.negate();
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<T> ... ts) {
        Assert.requireNonNull(ts, "ts must not be null");
        return Arrays.stream(ts).reduce(Predicate::or).orElseThrow(() -> new IllegalStateException("Unable to combine predicates together via logical OR"));
    }
}

