/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.Binding;
import io.r2dbc.mssql.PreparedStatementCache;
import io.r2dbc.mssql.util.Assert;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class IndefinitePreparedStatementCache
implements PreparedStatementCache {
    private final Map<String, Integer> preparedStatements = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Object> parsedSql = new ConcurrentHashMap<String, Object>();

    IndefinitePreparedStatementCache() {
    }

    @Override
    public int getHandle(String sql, Binding binding) {
        Assert.requireNonNull(sql, "SQL query must not be null");
        Assert.requireNonNull(binding, "Binding query must not be null");
        return this.preparedStatements.getOrDefault(IndefinitePreparedStatementCache.createKey(sql, binding), 0);
    }

    @Override
    public void putHandle(int handle, String sql, Binding binding) {
        Assert.requireNonNull(sql, "SQL query must not be null");
        Assert.requireNonNull(binding, "Binding query must not be null");
        this.preparedStatements.put(IndefinitePreparedStatementCache.createKey(sql, binding), handle);
    }

    @Override
    public <T> T getParsedSql(String sql, Function<String, T> parseFunction) {
        return (T)this.parsedSql.computeIfAbsent(sql, parseFunction);
    }

    @Override
    public int size() {
        return this.preparedStatements.size();
    }

    private static String createKey(String sql, Binding binding) {
        return sql + "-" + binding.getFormalParameters();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [preparedStatements=").append(this.preparedStatements);
        sb.append(", parsedSql=").append(this.parsedSql);
        sb.append(']');
        return sb.toString();
    }
}

