/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import io.r2dbc.spi.OutParameterMetadata;
import io.r2dbc.spi.Type;
import javax.annotation.Nonnull;

public final class MssqlColumnMetadata
implements ColumnMetadata,
OutParameterMetadata {
    private final Decodable decodable;
    private final Codecs codecs;

    MssqlColumnMetadata(Decodable decodable, Codecs codecs) {
        this.decodable = Assert.requireNonNull(decodable, "Decodable must not be null");
        this.codecs = Assert.requireNonNull(codecs, "Codecs must not be null");
    }

    public String getName() {
        return this.decodable.getName();
    }

    public Integer getPrecision() {
        return this.getNativeTypeMetadata().getPrecision();
    }

    public Integer getScale() {
        return this.getNativeTypeMetadata().getScale();
    }

    public Nullability getNullability() {
        return this.getNativeTypeMetadata().isNullable() ? Nullability.NULLABLE : Nullability.NON_NULL;
    }

    public Class<?> getJavaType() {
        return this.codecs.getJavaType(this.getNativeTypeMetadata());
    }

    public Type getType() {
        return this.getNativeTypeMetadata().getServerType();
    }

    @Nonnull
    public TypeInformation getNativeTypeMetadata() {
        return this.decodable.getType();
    }
}

