/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.mssql.MssqlConnectionConfiguration;
import io.r2dbc.mssql.MssqlConnectionFactory;
import io.r2dbc.mssql.OptionMapper;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.io.File;
import java.util.UUID;
import java.util.function.Function;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class MssqlConnectionFactoryProvider
implements ConnectionFactoryProvider {
    private final Logger logger = Loggers.getLogger(this.getClass());
    public static final Option<String> APPLICATION_NAME = Option.valueOf((String)"applicationName");
    public static final Option<UUID> CONNECTION_ID = Option.valueOf((String)"connectionId");
    public static final Option<String> HOSTNAME_IN_CERTIFICATE = Option.valueOf((String)"hostNameInCertificate");
    public static final Option<Object> PREFER_CURSORED_EXECUTION = Option.valueOf((String)"preferCursoredExecution");
    public static final Option<Boolean> SEND_STRING_PARAMETERS_AS_UNICODE = Option.valueOf((String)"sendStringParametersAsUnicode");
    public static final Option<Function<SslContextBuilder, SslContextBuilder>> SSL_CONTEXT_BUILDER_CUSTOMIZER = Option.valueOf((String)"sslContextBuilderCustomizer");
    public static final Option<Function<SslContextBuilder, SslContextBuilder>> SSL_TUNNEL = Option.valueOf((String)"sslTunnel");
    public static final Option<Boolean> TCP_KEEPALIVE = Option.valueOf((String)"tcpKeepAlive");
    public static final Option<Boolean> TCP_NODELAY = Option.valueOf((String)"tcpNoDelay");
    public static final Option<Boolean> TRUST_SERVER_CERTIFICATE = Option.valueOf((String)"trustServerCertificate");
    public static final Option<String> TRUST_STORE_TYPE = Option.valueOf((String)"trustStoreType");
    public static final Option<File> TRUST_STORE = Option.valueOf((String)"trustStore");
    public static final Option<char[]> TRUST_STORE_PASSWORD = Option.valueOf((String)"trustStorePassword");
    public static final String MSSQL_DRIVER = "sqlserver";
    public static final String ALTERNATE_MSSQL_DRIVER = "mssql";

    public MssqlConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        MssqlConnectionConfiguration.Builder builder = MssqlConnectionConfiguration.builder();
        OptionMapper mapper = OptionMapper.create(connectionFactoryOptions);
        mapper.fromTyped(APPLICATION_NAME).to(builder::applicationName);
        mapper.from(CONNECTION_ID).map(OptionMapper::toUuid).to(builder::connectionId);
        mapper.from(ConnectionFactoryOptions.CONNECT_TIMEOUT).map(OptionMapper::toDuration).to(builder::connectTimeout);
        mapper.fromTyped(ConnectionFactoryOptions.DATABASE).to(builder::database);
        mapper.fromTyped(HOSTNAME_IN_CERTIFICATE).to(builder::hostNameInCertificate);
        mapper.from(ConnectionFactoryOptions.LOCK_WAIT_TIMEOUT).map(OptionMapper::toDuration).to(builder::lockWaitTimeout);
        mapper.from(ConnectionFactoryOptions.PORT).map(OptionMapper::toInteger).to(builder::port);
        mapper.from(PREFER_CURSORED_EXECUTION).map(OptionMapper::toStringPredicate).to(builder::preferCursoredExecution);
        mapper.from(SEND_STRING_PARAMETERS_AS_UNICODE).map(OptionMapper::toBoolean).to(builder::sendStringParametersAsUnicode);
        mapper.from(ConnectionFactoryOptions.SSL).map(OptionMapper::toBoolean).to(ssl -> {
            if (ssl.booleanValue()) {
                builder.enableSsl();
            }
        });
        mapper.fromTyped(SSL_CONTEXT_BUILDER_CUSTOMIZER).to(builder::sslContextBuilderCustomizer);
        mapper.from(SSL_TUNNEL).map(it -> {
            if (it instanceof Boolean) {
                if (((Boolean)it).booleanValue()) {
                    return Function.identity();
                }
                return null;
            }
            return it;
        }).to(it -> {
            if (it != null) {
                builder.enableSslTunnel((Function)it);
            }
        });
        mapper.from(TCP_KEEPALIVE).map(OptionMapper::toBoolean).to(builder::tcpKeepAlive);
        mapper.from(TCP_NODELAY).map(OptionMapper::toBoolean).to(builder::tcpNoDelay);
        mapper.from(TRUST_SERVER_CERTIFICATE).map(OptionMapper::toBoolean).to(builder::trustServerCertificate);
        mapper.from(TRUST_STORE).map(OptionMapper::toFile).to(builder::trustStore);
        mapper.fromTyped(TRUST_STORE_TYPE).to(builder::trustStoreType);
        mapper.from(TRUST_STORE_PASSWORD).map(it -> it instanceof String ? ((String)it).toCharArray() : (char[])it).to(builder::trustStorePassword);
        builder.host(connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.HOST).toString());
        builder.password((CharSequence)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.PASSWORD));
        builder.username(connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.USER).toString());
        MssqlConnectionConfiguration configuration = builder.build();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Creating MssqlConnectionFactory with configuration [%s] from options [%s]", configuration, connectionFactoryOptions));
        }
        return new MssqlConnectionFactory(configuration);
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        Object driver = connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        if (driver == null || !driver.equals(MSSQL_DRIVER) && !driver.equals(ALTERNATE_MSSQL_DRIVER)) {
            return false;
        }
        if (!connectionFactoryOptions.hasOption(ConnectionFactoryOptions.HOST)) {
            return false;
        }
        if (!connectionFactoryOptions.hasOption(ConnectionFactoryOptions.PASSWORD)) {
            return false;
        }
        return connectionFactoryOptions.hasOption(ConnectionFactoryOptions.USER);
    }

    public String getDriver() {
        return MSSQL_DRIVER;
    }
}

