/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import java.io.File;
import java.time.Duration;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class OptionMapper {
    private final ConnectionFactoryOptions options;

    private OptionMapper(ConnectionFactoryOptions options) {
        this.options = options;
    }

    public static OptionMapper create(ConnectionFactoryOptions options) {
        return new OptionMapper(options);
    }

    public Source<Object> from(Option<?> option) {
        if (this.options.hasOption(option)) {
            return new AvailableSource<Object>(() -> this.options.getRequiredValue(option), option.name());
        }
        return NullSource.instance();
    }

    public <T> Source<T> fromTyped(Option<T> option) {
        if (this.options.hasOption(option)) {
            return new AvailableSource(() -> this.options.getRequiredValue(option), option.name());
        }
        return NullSource.instance();
    }

    static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean(value.toString());
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s to boolean", value));
    }

    static Duration toDuration(Object value) {
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value instanceof String) {
            return Duration.parse(value.toString());
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s to Duration", value));
    }

    static File toFile(Object value) {
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File(value.toString());
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s to File", value));
    }

    static int toInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s to integer", value));
    }

    static Predicate<String> toStringPredicate(Object value) {
        if (value instanceof Predicate) {
            return (Predicate)value;
        }
        if (value instanceof Boolean) {
            boolean choice = (Boolean)value;
            return s -> choice;
        }
        if (value instanceof String) {
            String stringValue = value.toString();
            if ("true".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
                return OptionMapper.toStringPredicate(Boolean.parseBoolean(stringValue));
            }
            try {
                Object predicate = Class.forName(stringValue).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (predicate instanceof Predicate) {
                    return OptionMapper.toStringPredicate(predicate);
                }
                throw new IllegalArgumentException("Value '" + value + "' must be an instance of Predicate");
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Cannot instantiate '" + value + "'", e);
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s to Predicate", value));
    }

    static UUID toUuid(Object value) {
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return UUID.fromString(value.toString());
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s to UUID", value));
    }

    private static class AvailableSource<T>
    implements Source<T> {
        private final Supplier<T> supplier;
        private final String optionName;

        private AvailableSource(Supplier<T> supplier, String optionName) {
            this.supplier = supplier;
            this.optionName = optionName;
        }

        @Override
        public <R> Source<R> map(Function<Object, R> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "Mapping function must not be null");
            Supplier<Object> supplier = () -> mappingFunction.apply(this.supplier.get());
            return new AvailableSource<Object>(supplier, this.optionName);
        }

        @Override
        public Otherwise to(Consumer<T> consumer) {
            Assert.requireNonNull(consumer, "Consumer must not be null");
            try {
                T value = this.supplier.get();
                if (value != null) {
                    consumer.accept(value);
                    return Otherwises.NONE;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot assign option %s", this.optionName), e);
            }
            return Otherwises.FALLBACK;
        }

        @Override
        public Otherwise to(Runnable consumer) {
            return this.to((T ignore) -> consumer.run());
        }
    }

    private static enum NullSource implements Source<Object>
    {
        INSTANCE;


        public static <T> Source<T> instance() {
            return INSTANCE;
        }

        @Override
        public <R> Source<R> map(Function<Object, R> mappingFunction) {
            return this;
        }

        @Override
        public Otherwise to(Consumer<Object> consumer) {
            return Otherwises.FALLBACK;
        }

        @Override
        public Otherwise to(Runnable consumer) {
            return Otherwises.FALLBACK;
        }
    }

    private static enum Otherwises implements Otherwise
    {
        NONE{

            @Override
            public void otherwise(Runnable consumer) {
            }
        }
        ,
        FALLBACK{

            @Override
            public void otherwise(Runnable consumer) {
                consumer.run();
            }
        };

    }

    public static interface Otherwise {
        public void otherwise(Runnable var1);
    }

    public static interface Source<T> {
        public <R> Source<R> map(Function<Object, R> var1);

        public Otherwise to(Consumer<T> var1);

        public Otherwise to(Runnable var1);
    }
}

