/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;

public class Encoded
extends AbstractReferenceCounted {
    private final TdsDataType dataType;
    private final ByteBuf value;

    protected Encoded(TdsDataType dataType, ByteBuf value) {
        this.dataType = dataType;
        this.value = value;
    }

    public static Encoded of(TdsDataType dataType, ByteBuf value) {
        return new Encoded(dataType, value);
    }

    public TdsDataType getDataType() {
        return this.dataType;
    }

    public ByteBuf getValue() {
        return this.value;
    }

    public Encoded touch(Object hint) {
        this.value.touch(hint);
        return this;
    }

    protected void deallocate() {
        this.value.release();
    }

    public String getFormalType() {
        for (SqlServerType serverType : SqlServerType.values()) {
            for (TdsDataType tdsType : serverType.getFixedTypes()) {
                if (tdsType != this.dataType) continue;
                return serverType.toString();
            }
        }
        throw new IllegalStateException(String.format("Cannot determine a formal type for %s", new Object[]{this.dataType}));
    }
}

