/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractNumericCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.SqlServerType;

final class IntegerCodec
extends AbstractNumericCodec<Integer> {
    static final IntegerCodec INSTANCE = new IntegerCodec();
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeNull(alloc, SqlServerType.INTEGER));

    private IntegerCodec() {
        super(Integer.class, value -> (int)value);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, Integer value) {
        return RpcEncoding.encodeFixed(allocator, SqlServerType.INTEGER, value, Encode::asInt);
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.INTEGER);
    }
}

