/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.CharacterEncoder;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcDirection;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.codec.UuidCodec;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.PlpLength;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import reactor.util.annotation.Nullable;

final class StringCodec
extends AbstractCodec<String> {
    static final StringCodec INSTANCE = new StringCodec();
    private static final Set<SqlServerType> SUPPORTED_TYPES = EnumSet.of(SqlServerType.CHAR, new SqlServerType[]{SqlServerType.NCHAR, SqlServerType.VARCHAR, SqlServerType.NVARCHAR, SqlServerType.VARCHARMAX, SqlServerType.NVARCHARMAX, SqlServerType.TEXT, SqlServerType.NTEXT, SqlServerType.GUID});

    private StringCodec() {
        super(String.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, String value) {
        RpcParameterContext.CharacterValueContext valueContext = context.getRequiredValueContext(RpcParameterContext.CharacterValueContext.class);
        SqlServerType serverType = context.getServerType();
        if (StringCodec.exceedsBigVarchar(context.getDirection(), value) || serverType == SqlServerType.VARCHARMAX || serverType == SqlServerType.NVARCHARMAX) {
            return CharacterEncoder.encodePlp(allocator, serverType, valueContext, value);
        }
        return CharacterEncoder.encodeBigVarchar(allocator, context.getDirection(), serverType, valueContext.getCollation(), valueContext.isSendStringParametersAsUnicode(), value);
    }

    @Override
    public boolean canEncodeNull(SqlServerType serverType) {
        return serverType == SqlServerType.VARCHAR || serverType == SqlServerType.NVARCHAR;
    }

    @Override
    public Encoded doEncodeNull(ByteBufAllocator allocator) {
        return this.encodeNull(allocator, SqlServerType.NVARCHAR);
    }

    @Override
    public Encoded encodeNull(ByteBufAllocator allocator, SqlServerType serverType) {
        return CharacterEncoder.encodeNull(serverType);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return SUPPORTED_TYPES.contains((Object)typeInformation.getServerType());
    }

    @Override
    @Nullable
    public String decode(@Nullable ByteBuf buffer, Decodable decodable, Class<? extends String> type) {
        Length length;
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        if (buffer == null) {
            return null;
        }
        if (decodable.getType().getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            PlpLength plpLength = PlpLength.decode(buffer, decodable.getType());
            length = Length.of(Math.toIntExact(plpLength.getLength()), plpLength.isNull());
        } else {
            length = Length.decode(buffer, decodable.getType());
        }
        return this.doDecode(buffer, length, decodable.getType(), (Class)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String doDecode(ByteBuf buffer, Length length, TypeInformation typeInformation, Class<? extends String> valueType) {
        if (length.isNull()) {
            return null;
        }
        if (typeInformation.getServerType() == SqlServerType.GUID) {
            Object uuid = UuidCodec.INSTANCE.doDecode(buffer, length, typeInformation, UUID.class);
            return uuid != null ? ((UUID)uuid).toString().toUpperCase(Locale.ENGLISH) : null;
        }
        Charset charset = typeInformation.getCharset();
        if (typeInformation.getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            CompositeByteBuf result = buffer.alloc().compositeBuffer();
            try {
                while (buffer.isReadable()) {
                    Length chunkLength = Length.decode(buffer, typeInformation);
                    result.addComponent(true, buffer.readRetainedSlice(chunkLength.getLength()));
                }
                String string = result.toString(charset);
                return string;
            }
            finally {
                result.release();
            }
        }
        String value = buffer.toString(buffer.readerIndex(), length.getLength(), charset);
        buffer.skipBytes(length.getLength());
        return valueType.cast(value);
    }

    static boolean exceedsBigVarchar(RpcDirection direction, String value) {
        int valueLength = value.length() * 2;
        boolean isShortValue = valueLength <= 8000;
        return !isShortValue || direction == RpcDirection.OUT;
    }
}

