/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.header;

import io.r2dbc.mssql.message.header.HeaderOptions;
import io.r2dbc.mssql.message.header.Status;
import io.r2dbc.mssql.message.header.Type;

class DefaultHeaderOptions
implements HeaderOptions {
    private static final HeaderOptions[][] HEADER_CACHE = new HeaderOptions[Type.values().length][255];
    private final Type type;
    private final Status status;

    static HeaderOptions get(Type value, Status status) {
        int index = status.getValue() - -128;
        return HEADER_CACHE[value.ordinal()][index];
    }

    DefaultHeaderOptions(Type type, Status status) {
        this.type = type;
        this.status = status;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean is(Status.StatusBit bit) {
        return this.status.is(bit);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append((Object)this.type);
        sb.append(", status=").append(this.status);
        sb.append(']');
        return sb.toString();
    }

    static {
        for (Type value : Type.values()) {
            for (byte b = -128; b < 127; b = (byte)(b + 1)) {
                int index = b - -128;
                DefaultHeaderOptions.HEADER_CACHE[value.ordinal()][index] = new DefaultHeaderOptions(value, Status.fromBitmask(b));
            }
        }
    }
}

