/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDoneToken;

public final class DoneInProcToken
extends AbstractDoneToken {
    public static final byte TYPE = -1;
    private static final DoneInProcToken[] INTERMEDIATE = new DoneInProcToken[48];
    private static final DoneInProcToken[] MORE_WITH_COUNT_CACHE = new DoneInProcToken[48];
    private static final DoneInProcToken[] DONE_WITH_COUNT_CACHE = new DoneInProcToken[48];
    private static final DoneInProcToken[] MORE_CACHE = new DoneInProcToken[48];
    private static final int DONE_WITH_COUNT = 16;
    private static final int MORE_WITH_COUNT = 17;
    private static final int MORE = 1;

    private DoneInProcToken(int status, int currentCommand, long rowCount) {
        super((byte)-1, status, currentCommand, rowCount);
    }

    public static DoneInProcToken create(long rowCount) {
        return DoneInProcToken.create0(16, 0, rowCount);
    }

    public static boolean isDone(Message message) {
        if (message instanceof DoneInProcToken) {
            return ((DoneInProcToken)message).isDone();
        }
        return false;
    }

    public static DoneInProcToken decode(ByteBuf buffer) {
        int status = Decode.uShort(buffer);
        int currentCommand = Decode.uShort(buffer);
        long rowCount = Decode.uLongLong(buffer);
        return DoneInProcToken.create0(status, currentCommand, rowCount);
    }

    private static DoneInProcToken create0(int status, int currentCommand, long rowCount) {
        if (rowCount >= 0L && rowCount < 48L) {
            switch (status) {
                case 0: {
                    return INTERMEDIATE[(int)rowCount];
                }
                case 16: {
                    return DONE_WITH_COUNT_CACHE[(int)rowCount];
                }
                case 17: {
                    return MORE_WITH_COUNT_CACHE[(int)rowCount];
                }
                case 1: {
                    return MORE_CACHE[(int)rowCount];
                }
            }
        }
        return new DoneInProcToken(status, currentCommand, rowCount);
    }

    @Override
    public String getName() {
        return "DONEINPROC";
    }

    static {
        for (int i = 0; i < INTERMEDIATE.length; ++i) {
            DoneInProcToken.INTERMEDIATE[i] = new DoneInProcToken(0, 0, i);
            DoneInProcToken.DONE_WITH_COUNT_CACHE[i] = new DoneInProcToken(16, 0, i);
            DoneInProcToken.MORE_WITH_COUNT_CACHE[i] = new DoneInProcToken(17, 0, i);
            DoneInProcToken.MORE_CACHE[i] = new DoneInProcToken(1, 0, i);
        }
    }
}

