/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.tds;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.ProtocolException;

public final class Redirect {
    private static final int PROTOCOL_TCP_IP = 0;
    private final String serverName;
    private final int port;

    public String getServerName() {
        return this.serverName;
    }

    public int getPort() {
        return this.port;
    }

    private Redirect(String serverName, int port) {
        this.serverName = serverName;
        this.port = port;
    }

    public static Redirect create(String serverName, int port) {
        return new Redirect(serverName, port);
    }

    public static Redirect decode(ByteBuf buffer) {
        int routingDataValueLength = buffer.readUnsignedShortLE();
        if (routingDataValueLength <= 5) {
            throw new ProtocolException("Decoding error, buffer is too short");
        }
        short protocol = buffer.readUnsignedByte();
        if (protocol != 0) {
            throw new ProtocolException("Unknown route protocol");
        }
        int port = buffer.readUnsignedShortLE();
        String serverName = Decode.unicodeUString(buffer);
        return Redirect.create(serverName, port);
    }
}

