/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.EscapeAwareNameMatcher;
import io.r2dbc.mssql.util.Assert;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

abstract class NamedCollectionSupport<N>
implements Collection<String> {
    private final N[] items;
    private final Map<String, N> nameKeyed;
    private final Function<N, String> nameMapper;
    private final String itemName;

    NamedCollectionSupport(N[] items, Map<String, N> nameKeyed, Function<N, String> nameMapper, String itemName) {
        this.nameMapper = nameMapper;
        this.itemName = itemName;
        if (this.shouldStripROWSTAT(items)) {
            this.items = (Object[])Array.newInstance(items.getClass().getComponentType(), items.length - 1);
            System.arraycopy(items, 0, this.items, 0, this.items.length);
            this.nameKeyed = NamedCollectionSupport.toMap(this.items, nameMapper);
        } else {
            this.items = items;
            this.nameKeyed = nameKeyed;
        }
    }

    static <N> Map<String, N> toMap(N[] named, Function<N, String> nameMapper) {
        HashMap<String, N> nameKeyed = new HashMap<String, N>(named.length, 1.0f);
        for (N n : named) {
            N old = nameKeyed.put(nameMapper.apply(n), n);
            if (old == null) continue;
            nameKeyed.put(nameMapper.apply(n), old);
        }
        return nameKeyed;
    }

    private boolean shouldStripROWSTAT(N[] columns) {
        return columns.length > 0 && "ROWSTAT".equals(this.nameMapper.apply(columns[columns.length - 1]));
    }

    N get(Object identifier) {
        Assert.requireNonNull(identifier, "Identifier must not be null");
        if (identifier instanceof Integer) {
            return this.get((Integer)identifier);
        }
        if (identifier instanceof String) {
            return this.get((String)identifier);
        }
        throw new IllegalArgumentException(String.format("Identifier [%s] is not a valid identifier. Should either be an Integer index or a String %s name.", identifier, this.itemName));
    }

    N get(int index) {
        if (this.items.length > index && index >= 0) {
            return this.items[index];
        }
        throw new IndexOutOfBoundsException(String.format("Index [%d] is larger than the number of %ss [%d]", index, this.itemName, this.items.length));
    }

    N get(String name) {
        N item = this.find(name);
        if (item == null) {
            throw new NoSuchElementException(String.format("[%s] does not exist in %s names %s", name, this.itemName, this.nameKeyed.keySet()));
        }
        return item;
    }

    @Nullable
    N find(String name) {
        N item = this.nameKeyed.get(name);
        if (item == null && (name = EscapeAwareNameMatcher.find(name, this.nameKeyed.keySet())) != null) {
            item = this.nameKeyed.get(name);
        }
        return item;
    }

    int getCount() {
        return this.items.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [").append(Arrays.stream(this.items).map(this.nameMapper).collect(Collectors.joining(", "))).append("]");
        return sb.toString();
    }

    @Override
    public int size() {
        return this.getCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.find((String)o) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        final Object[] items = this.items;
        return new Iterator<String>(){
            int index = 0;
            final /* synthetic */ NamedCollectionSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return items.length > this.index;
            }

            @Override
            public String next() {
                Object item = items[this.index++];
                return (String)this.this$0.nameMapper.apply(item);
            }
        };
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        for (int i = 0; i < this.size(); ++i) {
            a[i] = this.nameMapper.apply(this.get(i));
        }
        return a;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.nameMapper.apply(this.get(i));
        }
        return result;
    }

    @Override
    public boolean add(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

