/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.mssql.codec.BlobCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Codec;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.PlpLength;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Blob;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

class BinaryCodec
implements Codec<Object> {
    public static final BinaryCodec INSTANCE = new BinaryCodec();
    private static final byte[] NULL = ByteArray.fromBuffer(alloc -> {
        ByteBuf buffer = alloc.buffer(4);
        Encode.uShort(buffer, SqlServerType.VARBINARY.getMaxLength());
        Encode.uShort(buffer, 65535);
        return buffer;
    });
    private static final Set<SqlServerType> SUPPORTED_TYPES = EnumSet.of(SqlServerType.BINARY, SqlServerType.VARBINARY, SqlServerType.VARBINARYMAX, SqlServerType.IMAGE);

    private BinaryCodec() {
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "Value must not be null");
        return value instanceof byte[] || value instanceof ByteBuffer;
    }

    @Override
    public Encoded encode(ByteBufAllocator allocator, RpcParameterContext context, Object value) {
        int length;
        Object bytes;
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        Assert.requireNonNull(context, "RpcParameterContext must not be null");
        Assert.requireNonNull(value, "Value must not be null");
        if (value instanceof byte[]) {
            bytes = (byte[])value;
            if (BinaryCodec.exceedsBigVarbinary(((byte[])bytes).length)) {
                return BlobCodec.INSTANCE.encode(allocator, context, Blob.from((Publisher)Mono.just((Object)ByteBuffer.wrap(bytes))));
            }
            length = ((Object)bytes).length;
        } else {
            bytes = (ByteBuffer)value;
            if (BinaryCodec.exceedsBigVarbinary(bytes.remaining())) {
                return BlobCodec.INSTANCE.encode(allocator, context, Blob.from((Publisher)Mono.just((Object)bytes)));
            }
            length = bytes.remaining();
        }
        IntFunction<ByteBuf> encoder = actualLength -> {
            ByteBuf buffer;
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                buffer = RpcEncoding.prepareBuffer(allocator, TdsDataType.BIGVARBINARY.getLengthStrategy(), SqlServerType.VARBINARY.getMaxLength(), actualLength);
                buffer.writeBytes(bytes);
            } else {
                ByteBuffer bytes = (ByteBuffer)value;
                buffer = RpcEncoding.prepareBuffer(allocator, TdsDataType.BIGVARBINARY.getLengthStrategy(), SqlServerType.VARBINARY.getMaxLength(), actualLength);
                buffer.writeBytes(bytes.asReadOnlyBuffer());
            }
            return buffer;
        };
        return new VarbinaryEncoded(TdsDataType.BIGVARBINARY, Encoded.ofLengthAware(length, encoder));
    }

    @Override
    public boolean canEncodeNull(SqlServerType serverType) {
        return SUPPORTED_TYPES.contains((Object)serverType);
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "Type must not be null");
        return type.isAssignableFrom(byte[].class) || ByteBuffer.class.isAssignableFrom(type);
    }

    @Override
    public Class<Object> getType() {
        return ByteBuffer.class;
    }

    @Override
    public Encoded encodeNull(ByteBufAllocator allocator) {
        return new VarbinaryEncoded(TdsDataType.BIGVARBINARY, () -> Unpooled.wrappedBuffer((byte[])NULL));
    }

    @Override
    public Encoded encodeNull(ByteBufAllocator allocator, SqlServerType serverType) {
        return new VarbinaryEncoded(TdsDataType.BIGVARBINARY, () -> Unpooled.wrappedBuffer((byte[])NULL));
    }

    @Override
    public boolean canDecode(Decodable decodable, Class<?> type) {
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        return SUPPORTED_TYPES.contains((Object)decodable.getType().getServerType()) && this.canEncodeNull(type);
    }

    @Override
    @Nullable
    public Object decode(@Nullable ByteBuf buffer, Decodable decodable, Class<? extends Object> type) {
        Length length;
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        if (buffer == null) {
            return null;
        }
        if (decodable.getType().getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            PlpLength plpLength = PlpLength.decode(buffer, decodable.getType());
            length = Length.of(Math.toIntExact(plpLength.getLength()), plpLength.isNull());
        } else {
            length = Length.decode(buffer, decodable.getType());
        }
        if (length.isNull()) {
            return null;
        }
        return this.doDecode(buffer, length, decodable.getType(), type);
    }

    Object doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends Object> valueType) {
        byte[] bytes = new byte[length.getLength()];
        if (type.getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            int index = 0;
            while (buffer.isReadable()) {
                Length chunkLength = Length.decode(buffer, type);
                buffer.readBytes(bytes, index, chunkLength.getLength());
                index += chunkLength.getLength();
            }
        } else {
            buffer.readBytes(bytes);
        }
        if (valueType.isAssignableFrom(ByteBuffer.class) || ByteBuffer.class.isAssignableFrom(valueType)) {
            return ByteBuffer.wrap(bytes);
        }
        return bytes;
    }

    private static boolean exceedsBigVarbinary(int length) {
        return length > 8000;
    }

    static class VarbinaryEncoded
    extends RpcEncoding.HintedEncoded {
        private static final String FORMAL_TYPE = (Object)((Object)SqlServerType.VARBINARY) + "(" + 8000 + ")";

        VarbinaryEncoded(TdsDataType dataType, Supplier<ByteBuf> value) {
            super(dataType, SqlServerType.VARBINARY, value);
        }

        @Override
        public String getFormalType() {
            return FORMAL_TYPE;
        }
    }
}

