/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.mssql.util.ReferenceCountUtil;
import java.util.function.Function;

abstract class ByteArray {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] fromEncoded(Function<ByteBufAllocator, Encoded> encodeFunction) {
        Assert.notNull(encodeFunction, "Encode Function must not be null");
        Encoded encoded = encodeFunction.apply(ByteBufAllocator.DEFAULT);
        ByteBuf buffer = encoded.getValue();
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)buffer);
            return byArray;
        }
        finally {
            encoded.dispose();
            ReferenceCountUtil.maybeRelease(buffer);
        }
    }

    static byte[] fromBuffer(Function<ByteBufAllocator, ByteBuf> encodeFunction) {
        ByteBuf buffer = encodeFunction.apply(ByteBufAllocator.DEFAULT);
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)buffer);
            return byArray;
        }
        finally {
            buffer.release();
        }
    }

    private ByteArray() {
    }
}

